wp.domReady(() => {
  
  wp.blocks.unregisterBlockStyle(
    'core/image', ['rounded']
  );

  wp.blocks.registerBlockStyle( 'core/image', [ 
    {
      name: 'default',
      label: 'Default',
      isDefault: true,
    }
  ]);

  // allow only `core/embed/vimeo` and `core/embed/soundcloud`
  // <https://wordpress.stackexchange.com/a/379613>
  const allowedEmbedBlocks = [
    'vimeo',
    'soundcloud',
  ];
  wp.blocks.getBlockVariations('core/embed').forEach(function (blockVariation) {
    if (-1 === allowedEmbedBlocks.indexOf(blockVariation.name)) {
      wp.blocks.unregisterBlockVariation('core/embed', blockVariation.name);
    }
  });

  // <https://wordpress.stackexchange.com/a/392707>
  // Define our filter callback.
  function myPluginGettextFilter(translation, text, domain) {
    if ( text === 'Write an excerpt (optional)' ) {
      return "Write an excerpt (mandatory, else you can't Publish the post)";
    }

    return translation;
  }

  // Adding the filter
  wp.hooks.addFilter(
    'i18n.gettext',
    'my-plugin/override-write-an-excerpt-label',
    myPluginGettextFilter
  );

});
