const html = require('nanohtml')

function icon_panel_back() {
  return html`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <circle cx="9" cy="9" r="8.625" stroke="#212121" stroke-width="0.75"/>
    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.87537 9.4594L8.95798 12.3503L8.26522 13L4.34638 9.32484L4 9L4.34638 8.67516L8.26522 5L8.95798 5.64968L5.87537 8.54061H14V9.4594H5.87537Z" fill="#212121"/>
    </svg>
  `
}

function icon_panel_minimise() {
  return html`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M4 11L9 6L14 11" stroke="#212121"/>
    <circle cx="9" cy="9" r="8.625" transform="rotate(-180 9 9)" stroke="#212121" stroke-width="0.75"/>
    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.99998 5.29285L14.3535 10.6464L13.6464 11.3535L8.99998 6.70706L4.35353 11.3535L3.64642 10.6464L8.99998 5.29285Z" fill="#212121"/>
    </svg>
  `
}

function icon_panel_expand() {
  return html`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <circle cx="9" cy="9" r="8.625" transform="rotate(-180 9 9)" stroke="#212121" stroke-width="0.75"/>
    <path fill-rule="evenodd" clip-rule="evenodd" d="M9.00002 12.7072L3.64647 7.3536L4.35358 6.64649L9.00002 11.2929L13.6465 6.64649L14.3536 7.3536L9.00002 12.7072Z" fill="#212121"/>
    </svg>
  `
}

function icon_panel_close() {
  return html`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <circle cx="9" cy="9" r="8.625" stroke="#212121" stroke-width="0.75"/>
    <path d="M5 13L13 5" stroke="#212121"/>
    <path d="M13 13L5 5" stroke="#212121"/>
    </svg>
  `
}

function icon_panel_share() {
  return html`
    <svg width="18" height="18" xmlns="http://www.w3.org/2000/svg">
      <g fill="none" fill-rule="evenodd">
        <rect stroke="#6A7880" stroke-width=".75" fill="#E5E5E5" x=".375" y=".375" width="17.25" height="17.25" rx="1.625"/>
        <path d="M5.5 13v-2h-1v3h9v-3h-1v2h-7zm4.104-7.086v5.293h-1V5.914L5.457 9.061l-.707-.707 4-4L9.104 4l.353.354 4 4-.707.707-3.146-3.147z" fill="#212121"/>
      </g>
    </svg>
  `
}

module.exports = {icon_panel_back,
                  icon_panel_minimise,
                  icon_panel_expand,
                  icon_panel_close,
                  icon_panel_share}
