"use strict";

const localDB = require('./local-db')
const {origami} = require('./map/origami')
const scrollLock = require('./scroll-lock')

function splash (mapSize) {
  let db = localDB.getAll()

  if (db.splash) {
    // -- origami
    const origamiWrap = document.querySelector('#splash-origami')
    const svg = ear.svg(origamiWrap, (svg) => {
      svg.setAttributes(mapSize)
    })

    let splash = document.querySelector('#splash')
    const svgWrap = splash.querySelector('svg')
    const origamiGroup = svgWrap.g().setAttributes({id: 'splash-origami-group'})
    Array.from(origamiGroup.children).map(child => {
      child.remove()
    }) 

    // --

    // clicks
    let btnSplash = document.querySelector("#btn-splash")
    if (btnSplash !== null) {
      btnSplash.addEventListener('click', () => {
        // save this into localDB, so on next page refresh
        // the splash box won't appear
        db.splash = false 
        localDB.save(db)

        splash.classList.add('fade-out')
        setTimeout(() => {
          splash.remove()
          scrollLock(0)
        }, 900)
      })

    } else {
      console.log('splash, err => no DOM element found')
      return
    }

    return origamiGroup
  }

}

function splashPre() {
  let db = localDB.getAll()

  if (db.splash) {
    let splash = document.querySelector('#splash')
    splash.classList.remove('dn')

    scrollLock(1)
  }
}

function splashPost() {
  let splash = document.querySelector('#splash')
  splash.classList.remove('bgc-pistachio')
  splash.querySelector('#splash-op').classList.remove('dn')
}

module.exports = {splash, splashPre, splashPost}
