"use strict";

const DB = 'TWLA_READING_LIST'

// -- DB init
function dbInit() {
  try {
    if (sessionStorage.getItem(DB) === null) {
      sessionStorage.setItem(DB, JSON.stringify({
        articles: [],
        url: '',
        hash: '',
        nodeSelected: {id: null, type: ''}
      }))
    }

    // always reset node-selected
    // at each page reload
    let db = dbGetAll()
    db['nodeSelected'] = {id: null, type: ''}

    sessionStorage.setItem(DB, JSON.stringify(db))

  } catch (err) {
    console.log("can't use sessionStorage.")
  }
}

function dbGetAll() {
  try {
    const db = JSON.parse(sessionStorage.getItem(DB))
    return db
  } catch (err) {
    console.log("session.db can't be accessed =>", err)

    return {
      articles: [],
      url: '',
      hash: '',
      nodeSelected: {id: null, type: ''}
    }
  }
}

function dbSave(newState) {
  sessionStorage.setItem(DB, JSON.stringify(newState))
}

function dbExists(db) {
  if (sessionStorage.getItem(DB) !== null) {
    return true
  } else {
    return false
  }
}

function dbIsAdded(db, id) {
  return db.articles.find(article => article.id === id) ? true : false
}

function dbRemoveItemAll(id) {
  let db = dbGetAll()

  let articles = db.articles.filter(art => art.id !== id)
  db.articles = articles
  dbSave(db)

}

function dbRemoveLast() {
  let db = JSON.parse(sessionStorage.getItem(DB))

  // loop backwards and check if there is a chain of
  // `connection: true` items starting with a `node.type === 'tag'`
  // keyword: when removing a keyword and all articles connected to it,
  // don't remove other articles in the list only because part of
  // the keyword chain

  let isConnected = false
  const last = db.articles[db.articles.length -1]
  let nodesRemoved = []

  if (last.connection !== undefined && last.connection) {

    // loop backwards
    for (let idx = db.articles.length -1; idx >= 0; idx--) {
      let current = db.articles[idx]
      isConnected = current.connection !== undefined && current.connection

      nodesRemoved.push(current)

      if (isConnected && db.articles[idx -1].type === 'tag') {
        nodesRemoved.push(db.articles[idx -1])
        break
      }
    }

    // slice from article list start (0) to idx total - nodes-remove
    let articles = db.articles.slice(0, db.articles.length - nodesRemoved.length)
    db.articles = articles

  } else {
    nodesRemoved.push(db.articles[db.articles.length -1])
    db.articles.pop()
  }

  dbSave(db)

  return nodesRemoved
}

function dbRemoveAll() {
  sessionStorage.removeItem(DB)
}

module.exports = {
  init: dbInit,
  getAll: dbGetAll,
  save: dbSave,
  exists: dbExists,
  isAdded: dbIsAdded,
  removeItemAll: dbRemoveItemAll,
  removeLast: dbRemoveLast,
  removeAll: dbRemoveAll
}
