// <https://markus.oberlehner.net/blog/simple-solution-to-prevent-body-scrolling-on-ios/>
function scrollLock(action) {
  let $body = document.querySelector('body')
  let scrollPosition = 0

  // enable
  if (action === 1) {
    scrollPosition = window.pageYOffset;
    $body.style.overflow = 'hidden';
    $body.style.position = 'fixed';
    $body.style.top = `-${scrollPosition}px`;
    $body.style.width = '100%';
  } else if (action === 0) {
    $body.style.removeProperty('overflow');
    $body.style.removeProperty('position');
    $body.style.removeProperty('top');
    $body.style.removeProperty('width');
    window.scrollTo(0, scrollPosition);
  }
}

module.exports = scrollLock
