"use strict";
// - check if URL has not article ID
// - check if there's any article in sessionDB
// - set reader selection

const html = require('nanohtml')
const raw = require('nanohtml/raw')

const sessionDB = require('./session-db')
sessionDB.init()
let db = sessionDB.getAll()

let currentURL = window.location.href
if (currentURL.split('?').length < 2) {
  if (db.articles.length > 0) {
    generateNewURL(db, true)
  }
}

if (db.articles.length > 0) {
  createList(db.articles)
}

// --

function generateNewURL (db, reload) {
  const ids = db.articles.map(article => article.id)

    let newURL = window.location.origin + window.location.pathname + '?id=' +  ids.join('.')

  if (reload) {
    window.location.href = newURL

  } else {
    window.history.pushState(null, '', newURL)
  }
}

function createList(articles) {
  // -- remove existing article list and pagination
  const results = document.querySelector('#results')
  Array.from(results.children).map(child => {
    child.remove()
  })

  const pagination = document.querySelector('.nav-links')
  Array.from(pagination.children).map(child => {
    child.remove()
  })

  // --

  articles.map(article => {
    if (article.type === 'post') {
      const entry = createPostEntry(article)
      results.append(entry)

    } else if (article.type === 'tag') {
      const entry = createTagEntry(article)
      results.append(entry)
    }
  })

}

function createPostEntry(data) {

  function makeContributors(contributors) {
    return contributors.map((contributor, idx) => {
      const hasComma = contributors.length -1 === idx ? '' : ','
      
      return html`
        <a href="../../../${contributor.post_name}/index.html" class="tdn fgc-lait-green-hv">${contributor.post_title}${hasComma}</a>
      `
    })
  }

  function makeTags(tags) {
    const tagData = require('../tags.json')
    
    tags.map(t => {
      const tag = tags.find(tag => tag === t)

      return html`
        <a href="../../../tag/surrogate/index.html" class="bgc-lait-green bgc-black-hv fgc-white pr0-5 pb0-15 pl0-5 mr0-25 mb0-5 b-rad-2r h18p ft-barlow tdn">Surrogate</a>
      `
    })
  }

  function makeIcon(cats) {
    const index = {
      'contributor': html`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#FFE8D3" stroke="#212121" stroke-width="0.75"/>
</svg>`,
      'keyword': html`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 18C13.9764 18 18 13.9765 18 9C18 4.02352 13.9764 0 9 0C4.02357 0 0 4.02352 0 9C0 13.95 4.02357 18 9 18Z" fill="#6A7880"/>
</svg>`,
      'mixed-media': html`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#FFD3E8" stroke="#FF6161" stroke-width="0.75"/>
</svg>`,
      'photo-video': html`<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 19C14.9764 19 19 14.9765 19 10C19 5.02352 14.9764 1 10 1C5.02357 1 1 5.02352 1 10C1 14.95 5.02357 19 10 19Z" fill="#FFFCE2" stroke="#FFBBB2" stroke-width="0.75"/>
</svg>`,
      'reference': html`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#D3FAFF" stroke="#6A7880" stroke-width="0.75"/>
</svg>`,
      'sound': html`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#E5E5E5" stroke="#583DC5" stroke-width="0.75"/>
</svg>`,
      'text': html`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#CAEFD0" stroke="#889AA4" stroke-width="0.75"/>
</svg>`
    }

    return index[cats[0]['slug']]
  }

  function makeDate(date) {
    return new Date(date).toLocaleDateString('nl-NL', {
      timeZone: 'Europe/Berlin',
      day: '2-digit',
      month: '2-digit',
      year: 'numeric',
    }).replace(/-/g, '.')
  }
  
  // --
  return html`
    <div data-id="${data.id}" data-type="${data.type}" class="bg-db-child-hv w100 tb-mw-copy-post bg-mw100 x xdc bg-xdr xw md-xnw pt1 bb0-75-dash-dark-green psr">
      <div class="bg-child-hv bg-dn psa t0 r0 bg-ra bg-l0 pt2-9 bg-pt1-2 bg-ml-2-5">
        ${makeIcon(data.categories)}
      </div>
      <div data-type="header" class="w100 bg-w33 pr0-5 pb1">
        <div class="bg-w75 x xdc">
          <a data-type="title" href="../../../${data.slug}/index.html" class="ft-barlow fs-md-h3 db tdn fgc-lait-green-hv pr1-5 pb0-5 xo2 bg-xo1 bg-pr0">${data.title}</a>
        <div data-type="contributors" class="fs-sm-small bg-fs-md-small bg-pb0-5 xo3  bg-xo2">
          ${makeContributors(data.contributor)}
        </div>
        <div data-type="date" class="xo1 bg-xo3 fs-sm-small bg-fs-md-small pb0-5">${makeDate(data.date)}</div>
      </div>
      </div>
      <div data-type="description" class="w100 bg-w33 mra pb1 fs-sm-small fs-md-small bg-fs-md-small">${raw(data.excerpt)}</div>
      <div class="w100 bg-w25 pb1 fs-button-m dn bg-x xw xdr xas xacs">${makeTags(data.tags_force)}</div>
    </div>
  `
}

function createTagEntry(data) {
  return html`
    <div data-id="${data.id}" data-type="${data.type}" class="w100 tb-mw-copy-post bg-mw100 x xdr xw md-xnw pt1">
      <div data-type="tag" class="w100 bb0-75-dash-dark-green pr0-5 pb1">
      <a href="../../../tag/${ data.slug }/index.html" class="fgc-white tdn bgc-lait-green bgc-black-hv pr0-5 pl0-5 pb0-15 mr0-7 b-rad-2r ft-barlow fs-md-h3 dib tdn">${ data.name }</a>
      </div>
    </div>
  `
}
