"use strict";

const mapUITag = require('./map-ui-tag')
const mapUIPost = require('./map-ui-post')

function nodeUpdate(svg, point, nodeType, graph, EPSILON) {

  // add vertices to graph
  // we pass 0 as EPSILON to allow also overlapping (for now)
  // (kinda give all the faith to the user, ah!)
  ear.graph.add_vertices(graph, [point.map_location], 0);

  // populate graph with dots and return gDots
  // eg list of HTML nodes
  console.log('graph.vertices_coords =>', graph.vertices_coords)

  return graph.vertices_coords.map((coord, i) => {
    // add group
    const gDot = svg.g()
          .addClass(`g-${point.id}`)

    // add circle
    gDot.circle(coord)
      .radius(0.005)
      .fill('red')
      .addClass(`node-tag circle-${point.id} curp`)
      .setAttributes({'data-idx': i, 'data-id': point.id})


    // render UI level
    if (nodeType === 'tag') {
      mapUITag(point, points)

    } else if (nodeType === 'post') {
      mapUIPost(points[0], points)
    }

    return gDot
  })

}

module.exports = nodeUpdate
