"use-strict";
const sessionDB = require('./session-db')
const {mapListBox} = require('./map-list-box')
const mapListClose = require('./map-list-close')
const {navToggleMap} = require('./nav-toggle-buttons')
const splitBoxOpen = require('./expand-in-split-box').openBox
const {makeSplitReaderList} = require('./create-split-box-item')

function navToggleSwitch(articles, tags) {
  let mapResultBox = document.querySelector('#map-result-box')
  let splitBox = document.querySelector('#split-box') 

  const viewToggle = document.querySelector('#view-toggle')
  const mainButton = viewToggle.querySelector('#toggle-main')
  const splitButton = viewToggle.querySelector('#toggle-split')
  const readerButton = viewToggle.querySelector('#toggle-reader')

  mainButton.addEventListener('click', () => {
    if (!sessionDB.exists) {
      return
    } 

    let db = sessionDB.getAll()

    const isMapBoxOpen = !mapResultBox.classList.contains('dn')
    const isSplitBoxOpen = !splitBox.classList.contains('dn')

    let mapResultList = document.querySelector('#map-result-list')
    if (db.articles.length === 0) {
      navToggleMessage(viewToggle, "No Map selection yet!")

    } else if (isSplitBoxOpen) { 
      // check if we're inside a split-box article view
      // else we don't need to remove the split-box-list
      let splitBoxList = document.querySelector('#split-box-list')
      if (splitBoxList !== null) {
        Array.from(splitBoxList.children).forEach(item => {
          item.remove()
        })
      }

      splitBox.classList.add('dn')

      Array.from(mapResultList.children).map(child => child.remove())
      mapListBox(articles, tags, false, false)
      navToggleMap()

    } else if (isMapBoxOpen) {
      Array.from(mapResultList.children).forEach(item => {
        item.remove()
      })

      mapListBox(articles, tags, false, false)
      navToggleMap()
    } 

  })

  splitButton.addEventListener('click', () => {
    splitButtonClick(mapResultBox, splitBox, viewToggle, articles, tags)
  })
}

function splitButtonClick(mapResultBox, splitBox, viewToggle, articles, tags) {
  if (!sessionDB.exists) {
    return
  }

  let db = sessionDB.getAll()

  if (mapResultBox !== undefined) {
    const isMapBoxOpen = !mapResultBox.classList.contains('dn')
    const isSplitBoxOpen = !splitBox.classList.contains('dn')

    if (db.articles.length === 0) {
      navToggleMessage(viewToggle, "No Reader selection yet!")
    } else {

      const mapResultBoxWrap = document.querySelector('#map-result-box > .collapsible-wrapper')
      const isCollapsed = mapResultBoxWrap.classList.contains('collapsed')

      if (!isCollapsed) {
        const closeButton = document.querySelector('#map-list-close')
        mapListClose(closeButton, articles, tags)

        let mapResultList = document.querySelector('#map-result-list')
        Array.from(mapResultList.children).forEach(item => {
          item.remove()
        }) 
      }

      splitBoxOpen(articles, tags, false)
    }
  }

}

function navToggleMessage(viewToggle, msg) {
  function msgToggle () {
    let toggleMsg = document.querySelector('#map-toggle-message')
    toggleMsg.innerHTML = msg
    toggleMsg.classList.remove('dn')
    toggleMsg.style.left = `${viewToggle.getBoundingClientRect().right + 3}px`

    setTimeout(() => {
      toggleMsg.classList.add('dn')
    }, 3000)
  }

  msgToggle()

  window.addEventListener('resize', () => {
    msgToggle()
  })
}

module.exports = {navToggleSwitch, splitButtonClick}
