const get_camera_zoom = require('./camera').get_camera_zoom

function update_html_layer(tags, articles, isPreview) {
  // create article boxes
  if (!isPreview) {
    articles.map(article => update_html_article_box(article))
  }

  // create label for each tag
  tags.map(tag => update_html_tag_label(tag))
}

function update_html_tag_label(tag) {
  const LABEL_OFFSET = 40
  const SCALED_UP_PADDING = 16 * 1.5

  let htmlElement = tag.html_element
  let boundingBox = htmlElement.getBoundingClientRect()

  let zoom_factor = get_camera_zoom()

  // check if tag node is selected, and adjust position
  if (htmlElement.classList.contains('ts1-25')) {
    // update label left, top 
    htmlElement.style.left = `${(tag.map_location.x + SCALED_UP_PADDING / 2) - (boundingBox.width / 2) / zoom_factor}px`
    htmlElement.style.top = `${tag.map_location.y - ((LABEL_OFFSET + SCALED_UP_PADDING) )}px`

    // update circle cx, cy
    tag.svg_elements[0].removeAttribute('transform')

    const circleCx = tag.map_location.x
    const circleCy = tag.map_location.y
    const transformSVG = `translate(${circleCx} ${circleCy}) scale(1.5) translate(${Number(-circleCx)} ${Number(-circleCy)})`

    tag.svg_elements[0].setAttribute('transform', transformSVG)

  } else {
    htmlElement.style.left = `${tag.map_location.x - (boundingBox.width/2) / zoom_factor}px`
    htmlElement.style.top  = `${tag.map_location.y - LABEL_OFFSET}px`
  }


  tag.svg_elements.map(circle => {
    circle.setAttribute('cx', tag.map_location.x)
    circle.setAttribute('cy', tag.map_location.y)
  })

  tag.svg_elements_lines.map(line => {
    line.setAttribute('x2', tag.map_location.x)
    line.setAttribute('y2', tag.map_location.y)
  })
}

function update_html_article_box(article) {
  let htmlElement = article.html_element
  let boundingBox = htmlElement.getBoundingClientRect()

  // if the box has been scaled, make sure to use the original width and height
  if (htmlElement.style.transform == 'scale(1.25)' || htmlElement.classList.contains('ts1-25')) {
    boundingBox.width = boundingBox.width / 1.25
    boundingBox.height = boundingBox.height / 1.25
  }

  let zoom_factor = get_camera_zoom()

  htmlElement.style.left = `${article.map_location.x - (boundingBox.width/2) / zoom_factor}px`
  htmlElement.style.top  = `${article.map_location.y - (boundingBox.height/2) / zoom_factor}px`

  article.svg_elements.map(line => {
    line.setAttribute('x1', article.map_location.x)
    line.setAttribute('y1', article.map_location.y)
  })

}

module.exports = {update_html_layer,
                  update_html_tag_label,
                  update_html_article_box}
