const {generate_tag_event_handlers,
       move_tag_on_map} = require('./interactions.js')
const mapNodeReset = require('./map-node-reset')
const tagCreate = require('./tag-create')
const sessionDB = require('../session-db')
const {origami} = require('./origami')

function create_svg_layer(mapSize, tags, articles, isPreview) {
  // setup svg element

  const map = document.querySelector('#map-graph')
  const svg = ear.svg(map, (svg) => {
    svg.setAttributes(mapSize)
  })

  svg.classList.add('oh')

  let groupWrap = svg.g().setAttributes({id: 'svg-group-wrap'})

  // origami
  let group = groupWrap.g().setAttributes({id: 'origami-group-ui'})
  let opacity = 0.5
  origami(group, mapSize, tags, 0.5, true)

  let groupGBR = group.children[1].getBoundingClientRect()

  // create a group that holds all the elements,
  // this is for the panning and zooming
  let svgGroup = groupWrap.g().setAttributes({id: 'svg-group-ui'})

  // create dots for each tag
  tags.map(tag => create_svg_tag(svgGroup, tag, tags, articles, isPreview, mapSize))

  // create lines between articles & tags
  if (!isPreview) {
    articles.map(article => {
      article.tags.map(tag => {
        create_svg_line(svgGroup, article, tag)
      })
    })
  }

  // create new tag
  if (isPreview) {
    const tagCreateButton = document.querySelector('#tag-create')
    tagCreateButton.addEventListener('click', (e) => {
      tagCreate(svg, true, tags, articles, svgGroup, mapSize)
    }) 
  }

  if (isPreview) {
    move_tag_on_map(svg, tags)
  } 

  return svg
}

function create_svg_tag(svg, tag, tags, articles, isPreview, mapSize) {
  const {onClick, onHoverIn, onHoverOut} = generate_tag_event_handlers(tag, tags, articles, mapSize)

  let dot = svg.circle(tag.map_location)
      .radius(10)
      .fill('#6A7880')
      .addClass(`node-map node-tag circle-${tag.id} curp`)
      .setAttributes({'data-id': tag.id})
  
  if (!isPreview) {
    dot.addEventListener('click', onClick)
    dot.addEventListener('mouseover', onHoverIn)
    dot.addEventListener('mouseout', onHoverOut)
  }

  tag.svg_elements.push(dot)
}

function create_svg_line(svg, article, tag) {
  let line = svg.line(article.map_location.x, article.map_location.y, tag.map_location.x, tag.map_location.y)
    .strokeWidth(1)
    .stroke('#6A7880')
    .strokeDasharray('9')

  article.svg_elements.push(line)
  tag.svg_elements_lines.push(line)
}

// reset enlarged map-nodes
function map_reset_node_animation(svg, tags, articles) {

  svg.onRelease = (e) => {
    // check if node-tag or node-post have been clicked and enlarged
    // if yes, reset them
    let db = sessionDB.getAll()
    if (db.nodeSelected.id !== null) {
      const nodeSelected = db.nodeSelected.type === 'post'
            ? articles.find(article => article.id === db.nodeSelected.id)
            : tags.find(tag => tag.id === db.nodeSelected.id)

      mapNodeReset(nodeSelected, false)
    }

  }
}

module.exports = {create_svg_layer, create_svg_tag}
