const sessionDB = require('../session-db')
const {splitBoxLayout, populateSplitBox, makeSplitReaderList} = require('../create-split-box-item')

function splitReaderUpdate(tags, articles) {
  // update split-box if open
  // check if in list view or single node view

  let db = sessionDB.getAll()

  const splitBox = document.querySelector('#split-box')
  const splitBoxList = splitBox.querySelector('#split-box-list')
  const isSplitBoxOpen = !splitBox.classList.contains('dn')

  if (isSplitBoxOpen) {

    if (db.articles.length > 0) {
      if (splitBoxList === null) {
        // close single node view and return to list view

        // remove everything from split-box (article-view)
        Array.from(splitBox.children).map(block => block.remove())

        // and put back split-box basic view
        // if list has any item left
        // --
        let layout = splitBoxLayout()
        splitBox.appendChild(layout)

        populateSplitBox(splitBox)

      } else { 
        // remove everything currently on list
        // and rebuild list
        Array.from(splitBoxList.children)
          .map(child => child.remove())

        makeSplitReaderList(tags, articles)
      }

      if (splitBoxList !== null && splitBoxList.lastElementChild !== null) { 
        splitBoxList.lastElementChild.scrollIntoView()
      }

    } else {

      // close split-box
      Array.from(splitBox.children).map(block => block.remove())

      let layout = splitBoxLayout(splitBox)
      splitBox.appendChild(layout)
      splitBox.classList.add('dn')

    }

  }
}

module.exports = splitReaderUpdate
