// <https://svg.rabbitear.org/?example=origami-twist-fold>

const html = require('nanohtml')
const {getNodeColor} = require('./map-node-select') 
const origamiShape = require('./origami-shape')

function origami(origamiGroup, mapSize, opacity, hasBGPattern) {
  let patternGroup = origamiGroup.g().setAttributes({id: 'origami-pattern'})

  const SVGpolkaPattern = html`
    <pattern id="pattern-circles-tl" x="0" y="0" width="30" height="30" patternUnits="userSpaceOnUse" patternContentUnits="userSpaceOnUse">
        <circle cx="15" cy="0" r="1" fill="#889aa4" />
        <circle cx="0" cy="15" r="1" fill="#889aa4" />
        <circle cx="30" cy="15" r="1" fill="#889aa4" />
        <circle cx="15" cy="30" r="1" fill="#889aa4" />
    </pattern>
    <rect id="rect" x="-${mapSize.width / 2}" y="-${mapSize.height / 2}" width="${mapSize.width}" height="${mapSize.height}" fill="url(#pattern-circles-tl)" />
  `

  let shape = origamiShape(mapSize, opacity)

  // init SVG
  origamiGroup.setAttributes(mapSize)

  if (hasBGPattern) {
    patternGroup.appendChild(SVGpolkaPattern) 
  }

  origamiGroup.appendChild(shape)
}

function origamiUpdateColor(node) {
  let bgc = getNodeColor(node.categories)

  let defs = document.querySelector('#origami-polygon > defs')
  Array.from(defs.children).map(def => {
    def.children[1].setAttribute('stop-color', bgc)
  })
}

module.exports = {origami, origamiUpdateColor}
