const html = require('nanohtml')

function origamiShape(mapSize, opacity) {
  return html`
    <svg id="origami-polygon" width="${mapSize.width}" height="${mapSize.height}" x="${-(mapSize.width / 2)}" y="${-(mapSize.height / 2)}" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M3270.98 3299.3L2960.31 3563.88L2527.7 5203.14L4269.54 4032.67L4505.58 3398.19L3270.98 3299.3Z" fill="url(#paint0_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3265.45 4400.92L2833.66 5327.39L2527.89 5202.91L2960.51 3563.65L3265.45 4400.92Z" fill="url(#paint1_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2925.74 5067.16L2449.61 4077.14L1908.17 3961.92L2528.35 5204.07L2834.12 5328.56L2925.74 5067.16Z" fill="url(#paint2_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2296.62 4206.84L1911.51 4175.11L1908.17 3961.92L2449.61 4077.14L2296.62 4206.84Z" fill="url(#paint3_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2818.67 4071.34L3016.05 3823.16L3003.05 3061.12L1908.48 3961.56L1911.82 4174.74L2818.67 4071.34Z" fill="url(#paint4_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2444.49 3341.71L2858.99 3988.74L4269.47 4032.92L3002.02 3060.79L2477.26 3192.09L2444.49 3341.71Z" fill="url(#paint5_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3172.48 3560.18L4456.44 3362.16L4505.31 3397.97L4269.27 4032.44L2858.79 3988.27L3172.48 3560.18Z" fill="url(#paint6_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4270.47 4034.08L2528.62 5204.55L1908.44 3962.4L3003.01 3061.96L4270.47 4034.08Z" fill="url(#paint7_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3002.29 3060.47L3015.28 3822.52L2477.53 3191.77L3002.29 3060.47Z" fill="url(#paint8_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4413.9 4391.03L4737.35 4142.22L5250.96 2526.51L3453.06 3608.9L3185.75 4230.85L4413.9 4391.03Z" fill="url(#paint9_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4474.22 3291.04L4951.55 2387.19L5250.75 2526.73L4737.14 4142.44L4474.22 3291.04Z" fill="url(#paint10_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4846.64 2642.52L5272.95 3655L5807.98 3797L5250.35 2525.54L4951.15 2386L4846.64 2642.52Z" fill="url(#paint11_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5432.2 3533.07L5815.25 3583.91L5807.98 3797L5272.95 3655L5432.2 3533.07Z" fill="url(#paint12_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4904.06 3642.43L4694.58 3880.48L4669.66 4642.24L5807.66 3797.35L5814.93 3584.26L4904.06 3642.43Z" fill="url(#paint13_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5241.48 4389.77L4859.67 3722.92L3453.14 3608.65L4670.67 4642.61L5201.31 4537.58L5241.48 4389.77Z" fill="url(#paint14_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4525.26 4135.36L3233.04 4269.28L3186.01 4231.08L3453.31 3609.13L4859.85 3723.41L4525.26 4135.36Z" fill="url(#paint15_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3452.2 3607.43L5250.1 2525.05L5807.74 3796.51L4669.74 4641.4L3452.2 3607.43Z" fill="url(#paint16_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4670.39 4642.92L4695.31 3881.16L5201.03 4537.88L4670.39 4642.92Z" fill="url(#paint17_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5681.89 3612.68L5690.18 4020.67L6685.74 5392.96L6881.64 3303.55L6539.71 2719.29L5681.89 3612.68Z" fill="url(#paint18_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6531.4 4314.07L6975.56 5234.67L6685.68 5392.66L5690.13 4020.37L6531.4 4314.07Z" fill="url(#paint19_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6832.33 4998.7L5764.44 4740.9L5332.61 5087.25L6686.88 5393.04L6976.76 5235.05L6832.33 4998.7Z" fill="url(#paint20_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5768.06 4941.44L5499.8 5219.56L5332.61 5087.25L5764.44 4740.9L5768.06 4941.44Z" fill="url(#paint21_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5993.49 4451.47L5926.22 4141.58L5327.92 3669.43L5332.52 5086.78L5499.71 5219.09L5993.49 4451.47Z" fill="url(#paint22_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5191.74 4279.5L5955.05 4367.97L6881.79 3303.76L5327.02 3670.03L5096.62 4159.44L5191.74 4279.5Z" fill="url(#paint23_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5821.57 3854.04L6480.71 2734.53L6539.37 2719.35L6881.3 3303.61L5954.55 4367.82L5821.57 3854.04Z" fill="url(#paint24_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6883.32 3303.72L6687.42 5393.14L5333.15 5087.34L5328.55 3670L6883.32 3303.72Z" fill="url(#paint25_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5326.94 3669.62L5925.24 4141.77L5096.54 4159.03L5326.94 3669.62Z" fill="url(#paint26_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5583.28 6373.21L5865.68 7280.31L5678.31 7368.19L3064.65 6481.02L3233.73 6159.08L4452.85 5779.54L5583.28 6373.21Z" fill="url(#paint27_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5687.97 7006.24L4439.2 6740.01L4389.11 6772.49L3841.01 7470.71L5678.41 7368.31L5865.78 7280.43L5687.97 7006.24Z" fill="url(#paint28_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4307.58 7384.7L4284.2 6885.11L3467.99 5467.37L3840.88 7470.1L4093.07 7620.28L4307.58 7384.7Z" fill="url(#paint29_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3631.3 6464.36L3411.42 5445.6L3467.8 5467.59L4284.02 6885.33L3631.3 6464.36Z" fill="url(#paint30_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3219.87 5580.84L3064.58 6480.73L5678.24 7367.9L3467.95 5467.56L3411.56 5445.57L3219.87 5580.84Z" fill="url(#paint31_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3467.99 5467.37L5678.28 7367.7L3840.88 7470.1L3467.99 5467.37Z" fill="url(#paint32_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3840.86 7470.02L4388.95 6771.8L4093.04 7620.2L3840.86 7470.02Z" fill="url(#paint33_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2458.62 1975L2589.92 2361.38L3953.89 3368.3L3508.69 1317.49L3006.07 864.008L2458.62 1975Z" fill="url(#paint34_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3480.48 2386.61L4182.26 3129.77L3953.75 3368.03L2589.77 2361.11L3480.48 2386.61Z" fill="url(#paint35_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3974.37 2948.17L2878.52 3025.42L2571.67 3486.15L3955 3368.04L4183.52 3129.77L3974.37 2948.17Z" fill="url(#paint36_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2942.62 3215.48L2771.04 3561.7L2571.67 3486.15L2878.52 3025.42L2942.62 3215.48Z" fill="url(#paint37_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3009.31 2680.27L2851.47 2405.24L2138.39 2136.15L2571.44 3485.73L2770.82 3561.28L3009.31 2680.27Z" fill="url(#paint38_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2193.09 2758.83L2947.42 2612.31L3508.89 1317.65L2137.71 2136.99L2066.12 2673.17L2193.09 2758.83Z" fill="url(#paint39_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2664.76 2162.81L2954.44 896.383L3005.76 864.172L3508.38 1317.66L2946.9 2612.32L2664.76 2162.81Z" fill="url(#paint40_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3510.35 1317.15L3955.55 3367.96L2572.21 3486.07L2139.16 2136.5L3510.35 1317.15Z" fill="url(#paint41_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2137.51 2136.63L2850.59 2405.71L2065.93 2672.8L2137.51 2136.63Z" fill="url(#paint42_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4045.24 2854.78L4368.68 2605.97L4882.3 990.262L3084.39 2072.65L2817.09 2694.6L4045.24 2854.78Z" fill="url(#paint43_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4105.56 1754.8L4582.89 850.948L4882.09 990.484L4368.47 2606.19L4105.56 1754.8Z" fill="url(#paint44_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4477.98 1106.27L4904.28 2118.75L5439.32 2260.75L4881.69 989.293L4582.49 849.757L4477.98 1106.27Z" fill="url(#paint45_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5063.54 1996.82L5446.59 2047.67L5439.32 2260.75L4904.28 2118.75L5063.54 1996.82Z" fill="url(#paint46_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4535.39 2106.18L4325.91 2344.24L4300.99 3105.99L5439 2261.1L5446.26 2048.01L4535.39 2106.18Z" fill="url(#paint47_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4872.82 2853.53L4491.01 2186.68L3084.47 2072.4L4302.01 3106.36L4832.65 3001.33L4872.82 2853.53Z" fill="url(#paint48_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4156.59 2599.12L2864.37 2733.04L2817.34 2694.84L3084.65 2072.89L4491.18 2187.16L4156.59 2599.12Z" fill="url(#paint49_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3083.54 2071.19L4881.44 988.801L5439.07 2260.26L4301.07 3105.15L3083.54 2071.19Z" fill="url(#paint50_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4301.72 3106.67L4326.64 2344.92L4832.36 3001.64L4301.72 3106.67Z" fill="url(#paint51_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2056.99 4827.31L1990.89 4538.9L1081.62 3711.6L1250.89 5223.82L1579.85 5588.14L2056.99 4827.31Z" fill="url(#paint52_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1350.4 4454.75L899.229 3866.75L1081.7 3711.81L1990.98 4539.1L1350.4 4454.75Z" fill="url(#paint53_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1035.74 4013.13L1831.89 4038.55L2087.34 3728.95L1080.8 3711.71L898.322 3866.65L1035.74 4013.13Z" fill="url(#paint54_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1799.73 3896.72L1949.13 3659.69L2087.34 3728.95L1831.89 4038.55L1799.73 3896.72Z" fill="url(#paint55_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1712 4277.83L1805.49 4487.89L2299.9 4734.79L2087.47 3729.27L1949.26 3660.01L1712 4277.83Z" fill="url(#paint56_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2306.55 4281.59L1751.61 4331.43L1250.75 5223.69L2300.46 4734.23L2391.79 4352.79L2306.55 4281.59Z" fill="url(#paint57_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1922.21 4676.58L1619.48 5568.61L1580.08 5588.04L1251.12 5223.73L1751.98 4331.46L1922.21 4676.58Z" fill="url(#paint58_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1249.67 5223.94L1080.4 3711.72L2086.94 3728.96L2299.37 4734.48L1249.67 5223.94Z" fill="url(#paint59_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2300.57 4734.51L1806.15 4487.62L2391.91 4353.07L2300.57 4734.51Z" fill="url(#paint60_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6826.44 1656.31L6510.69 1877.63L4908.69 1884.15L6392.74 568.905L7029.08 503.647L6826.44 1656.31Z" fill="url(#paint61_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5817.56 1399.84L4867.69 1574.82L4908.95 1884.03L6510.94 1877.51L5817.56 1399.84Z" fill="url(#paint62_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5127.56 1552.38L5920.01 2222.89L5896.85 2745.45L4907.99 1883.33L4866.73 1574.12L5127.56 1552.38Z" fill="url(#paint63_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5765.07 2332.03L5702.66 2691.78L5896.85 2745.45L5920.01 2222.89L5765.07 2332.03Z" fill="url(#paint64_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6012.93 1886.71L6286.78 1765.11L6980.67 1957.91L5897.26 2745.25L5703.07 2691.59L6012.93 1886.71Z" fill="url(#paint65_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6591.44 2402.16L6098.05 1869.44L6392.5 568.907L6980.72 1958.93L6736.06 2407.71L6591.44 2402.16Z" fill="url(#paint66_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6564.45 1684.46L7050.37 557.144L7029.22 503.942L6392.88 569.2L6098.44 1869.74L6564.45 1684.46Z" fill="url(#paint67_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6391.67 567.721L4907.62 1882.97L5896.48 2745.09L6979.89 1957.74L6391.67 567.721Z" fill="url(#paint68_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6981.08 1958.75L6287.18 1765.96L6736.41 2407.54L6981.08 1958.75Z" fill="url(#paint69_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2142.41 5246.41L2070.19 5057.42L2273.14 4881.17L4371.32 5315.4L3252.79 5742.81L2142.41 5246.41Z" fill="url(#paint70_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2957.29 5548.46L3823.77 5299.5L4249.35 4364.89L2273.13 4881.11L2070.19 5057.35L2957.29 5548.46Z" fill="url(#paint71_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3690.75 5014.14L3951.52 4297.51L4249.37 4364.78L3823.79 5299.39L3690.75 5014.14Z" fill="url(#paint72_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3908.81 4749.38L4069.83 4944.41L4589.23 5048.9L4249.81 4365.02L3951.96 4297.75L3908.81 4749.38Z" fill="url(#paint73_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4198.28 4535.42L3564.3 4810.59L3591.51 5911.71L4589.24 5048.8L4569.46 4681.91L4198.28 4535.42Z" fill="url(#paint74_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4055.28 4995.56L4389.77 5734.04L3591.01 5911.63L3563.8 4810.51L4055.28 4995.56Z" fill="url(#paint75_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4384.8 5328.47L4371.29 5315.29L2273.11 4881.06L3591.01 5911.63L4389.77 5734.04L4384.8 5328.47Z" fill="url(#paint76_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3591.51 5911.71L2273.61 4881.14L4249.83 4364.92L4589.24 5048.8L3591.51 5911.71Z" fill="url(#paint77_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4589.23 5048.9L4069.83 4944.41L4569.45 4682.01L4589.23 5048.9Z" fill="url(#paint78_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5345.81 2508.96L5397.42 2443.31L5650.62 2448.48L7778.18 3220.72L7195.05 3962.57L6227.67 4078.44L5461.69 3476.34L5345.81 2508.96Z" fill="url(#paint79_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5919.31 3165.58L6632.25 3280.64L7259.47 2748.37L5651.03 2448.54L5397.83 2443.38L5919.31 3165.58Z" fill="url(#paint80_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6633.12 3028.46L7066.54 2597.98L7259.48 2748.31L6632.27 3280.59L6633.12 3028.46Z" fill="url(#paint81_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M7060.05 2803L7664.86 3356.95L7271.67 3359.64L6941.27 2808.21L7060.05 2803Z" fill="url(#paint82_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M7777.48 3251.41L7778.4 3220.73L5650.84 2448.49L7272.05 3359.75L7665.25 3357.06L7777.48 3251.41Z" fill="url(#paint83_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5650.58 2448.42L7259.02 2748.24L7271.79 3359.68L5650.58 2448.42Z" fill="url(#paint84_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M7259.02 2748.24L7066.07 2597.9L6941.4 2808.25L7271.79 3359.68L7259.02 2748.24Z" fill="url(#paint85_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4115.51 4304.39L4175.47 4222.78L4441.07 4228.69L5314.86 5930.78L5118.54 5960.81L4273.97 5340.33L4115.51 4304.39Z" fill="url(#paint86_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4701.66 5010.61L4776.1 5025.41L5315.42 4776.68L4441.26 4229.37L4175.66 4223.46L4701.66 5010.61Z" fill="url(#paint87_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4712.24 4782.5L4579.07 5622.36L5117.27 6111.47L5315.21 4776.09L5047.99 4538.66L4712.24 4782.5Z" fill="url(#paint88_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4770.44 5572.93L5217.07 5836.22L5117.27 6111.47L4579.07 5622.36L4770.44 5572.93Z" fill="url(#paint89_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4793.46 5833.3L4457.62 6541.97L4310.26 6311.98L4768.4 5763.07L4793.46 5833.3Z" fill="url(#paint90_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4721.28 6538.65L5315.02 5931.25L4441.24 4229.16L4310.18 6311.66L4457.53 6541.65L4721.28 6538.65Z" fill="url(#paint91_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4310.08 6311.26L4441.13 4228.77L5315.29 4776.08L5117.34 6111.45L4310.08 6311.26Z" fill="url(#paint92_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4310.08 6311.26L5117.34 6111.45L5217.14 5836.2L4768.21 5762.35L4310.08 6311.26Z" fill="url(#paint93_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5315.42 4776.68L4776.1 5025.41L5048.2 4539.24L5315.42 4776.68Z" fill="url(#paint94_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1285.94 3274.2L1269.29 3238.65L1374.37 1638.11L2755.51 3562.34L2756.79 3574.54L2477.25 3705.48L1285.94 3274.2Z" fill="url(#paint95_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1930.91 2204.4L1794.52 1583.5L1374.33 1638.02L1269.25 3238.56L1930.91 2204.4Z" fill="url(#paint96_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1820.98 2214.46L1125.09 2971.15L257.557 2828.33L1374.39 1638.26L1794.59 1583.74L1820.98 2214.46Z" fill="url(#paint97_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1028.26 2752.7L443.465 2527.12L257.557 2828.33L1125.09 2971.15L1028.26 2752.7Z" fill="url(#paint98_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M917.138 2957.65L933.413 3299.2L674.199 3743.23L257.523 2828.24L443.43 2527.03L917.138 2957.65Z" fill="url(#paint99_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M741.458 3179.3L1627.89 3043.8L2756.01 3562.27L674.706 3743.09L488.795 3523.14L741.458 3179.3Z" fill="url(#paint100_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1824.02 3357.62L2757.53 3574.1L2756.25 3561.9L1628.13 3043.44L1824.02 3357.62Z" fill="url(#paint101_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2755.53 3562.48L1374.39 1638.24L257.552 2828.31L674.229 3743.3L2755.53 3562.48Z" fill="url(#paint102_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M674.674 3743.02L933.888 3298.99L488.763 3523.07L674.674 3743.02Z" fill="url(#paint103_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5229.11 5615.69L5808.79 5077.81L5794.02 4818L4999.57 5406.5L4970.1 5606L5229.11 5615.69Z" fill="url(#paint104_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5592.89 5109.88L6472 5996.64L6530.38 5996.89L7352.85 5719.21L5794.65 4818.75L5593.71 4919.82L5592.89 5109.88Z" fill="url(#paint105_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6924.62 5538.49L6440.37 6359.49L6584.51 7556.98L7352.22 5718.61L7226.33 5460.65L6924.62 5538.49Z" fill="url(#paint106_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6646.67 6571.18L6633.66 7578.97L6584.58 7557.04L6440.44 6359.55L6646.67 6571.18Z" fill="url(#paint107_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6811.26 7416.26L6863.9 6168.69L6350.14 5609.66L4999.93 5406.94L6584.88 7557.26L6633.96 7579.2L6811.26 7416.26Z" fill="url(#paint108_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5927.39 5856.46L4970.12 5606.02L4999.59 5406.52L6349.79 5609.24L5927.39 5856.46Z" fill="url(#paint109_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M6584.51 7556.98L4999.56 5406.66L5794.02 4818.15L7352.22 5718.61L6584.51 7556.98Z" fill="url(#paint110_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M5793.87 4818.2L5808.64 5078.01L5592.93 4919.26L5793.87 4818.2Z" fill="url(#paint111_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M7352.96 5719.06L6530.5 5996.74L7227.07 5461.09L7352.96 5719.06Z" fill="url(#paint112_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3373.31 2246.61L3093.7 1236.14L2013.81 883.003L3127.26 2337.47L3299.49 2376.93L3373.31 2246.61Z" fill="url(#paint113_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3088.87 1239.95L2041.45 1117.19L1933.86 981.026L2013.79 883.001L3093.68 1236.14L3088.87 1239.95Z" fill="url(#paint114_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2720.9 1376.59L3362.53 1164.49L4059.45 282.54L2013.79 882.573L1933.85 980.599L2720.9 1376.59Z" fill="url(#paint115_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3395.03 787.167L4036.92 247.083L4059.44 282.623L3362.52 1164.58L3395.03 787.167Z" fill="url(#paint116_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3840.91 337.016L3533.24 1166.01L4003.42 1360.11L4059.49 282.631L4036.98 247.091L3840.91 337.016Z" fill="url(#paint117_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3603.82 1011.39L3777.11 946.604L4003.37 1360.49L3533.18 1166.39L3603.82 1011.39Z" fill="url(#paint118_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3240.74 1473.29L3299.49 2376.19L3127.26 2336.74L3163.43 1405.43L3240.74 1473.29Z" fill="url(#paint119_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4003.43 1360.03L3127.3 2337.05L2013.85 882.581L4059.51 282.548L4003.43 1360.03Z" fill="url(#paint120_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M4003.37 1360.49L3777.11 946.604L3163.41 1406.2L3127.24 2337.51L4003.37 1360.49Z" fill="url(#paint121_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M3588.23 6129.17L2384.73 6179.2L1708.62 7295.77L3625.89 6428.14L3714.85 6245.68L3588.23 6129.17Z" fill="url(#paint122_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2387.73 6185.6L1977.88 7325.76L1797.52 7410.74L1708.62 7295.79L2384.72 6179.21L2387.73 6185.6Z" fill="url(#paint123_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2444.91 6632.92L2374.49 5859.73L1568.84 4850.41L1708.14 7295.68L1797.04 7410.63L2444.91 6632.92Z" fill="url(#paint124_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1960.7 5725.2L1523.31 4866.4L1568.93 4850.44L2374.58 5859.76L1960.7 5725.2Z" fill="url(#paint125_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1572.95 5109.14L2420.59 5669.09L2760.11 5193.43L1568.96 4850.38L1523.33 4866.34L1572.95 5109.14Z" fill="url(#paint126_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2265.93 5549.88L2238.51 5339.11L2760.52 5193.59L2421 5669.25L2265.93 5549.88Z" fill="url(#paint127_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2688.36 6076.35L3714.03 6245.49L3625.07 6427.95L2592.31 6145.21L2688.36 6076.35Z" fill="url(#paint128_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2760.02 5193.4L3625.43 6427.99L1708.16 7295.62L1568.87 4850.35L2760.02 5193.4Z" fill="url(#paint129_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2760.52 5193.59L2238.51 5339.11L2593.16 6145.43L3625.92 6428.18L2760.52 5193.59Z" fill="url(#paint130_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2464.93 1734.66L2012.21 2164.22L2026.15 2369.12L2647.91 1897.71L2669.41 1740.02L2464.93 1734.66Z" fill="url(#paint131_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2182.3 2137.02L1480.75 1444.96L1434.67 1445.28L788.07 1671.64L2025.64 2368.53L2183.33 2287.01L2182.3 2137.02Z" fill="url(#paint132_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1127.6 1810.49L1502.52 1158.33L1378.24 214.604L788.571 1672.11L890.187 1874.57L1127.6 1810.49Z" fill="url(#paint133_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1337.85 993.101L1339.25 197.685L1378.18 214.562L1502.47 1158.29L1337.85 993.101Z" fill="url(#paint134_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1200.54 327.654L1169.97 1312.64L1580.32 1749.27L2647.62 1897.37L1377.94 214.387L1339.02 197.51L1200.54 327.654Z" fill="url(#paint135_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1911.76 1550.8L2669.39 1740.01L2647.9 1897.7L1580.6 1749.6L1911.76 1550.8Z" fill="url(#paint136_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M1378.24 214.604L2647.91 1897.59L2026.14 2369L788.571 1672.11L1378.24 214.604Z" fill="url(#paint137_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M2026.26 2368.97L2012.32 2164.06L2183.95 2287.44L2026.26 2368.97Z" fill="url(#paint138_linear_4698:34430)" fill-opacity="${opacity}"/>
      <path d="M787.98 1671.76L1434.58 1445.4L889.597 1874.23L787.98 1671.76Z" fill="url(#paint139_linear_4698:34430)" fill-opacity="${opacity}"/>
      <defs>
      <linearGradient id="paint0_linear_4698:34430" x1="4181.91" y1="3125.44" x2="1291" y2="6556.05" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint1_linear_4698:34430" x1="3357.97" y1="3898.59" x2="1689.37" y2="5878.7" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint2_linear_4698:34430" x1="2683.67" y1="4274.37" x2="1800.51" y2="5322.41" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint3_linear_4698:34430" x1="2262.92" y1="3919.82" x2="1803.74" y2="4464.71" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint4_linear_4698:34430" x1="3099.87" y1="3142.7" x2="1406.8" y2="5151.84" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint5_linear_4698:34430" x1="3538.3" y1="3416.78" x2="2585.34" y2="4547.65" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint6_linear_4698:34430" x1="4242.9" y1="3176.84" x2="2595.96" y2="5131.23" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint7_linear_4698:34430" x1="3562.2" y1="3437.24" x2="1365.26" y2="6044.33" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint8_linear_4698:34430" x1="3072.76" y1="3119.86" x2="2447.32" y2="3862.07" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint9_linear_4698:34430" x1="3495.45" y1="4519.36" x2="6553.42" y2="1236.78" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint10_linear_4698:34430" x1="4356.82" y1="3788.15" x2="6121.85" y2="1893.48" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint11_linear_4698:34430" x1="5048.99" y1="3446.36" x2="5983.18" y2="2443.55" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint12_linear_4698:34430" x1="5451.58" y1="3821.41" x2="5937.29" y2="3300.03" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint13_linear_4698:34430" x1="4577.02" y1="4555.93" x2="6367.92" y2="2633.49" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint14_linear_4698:34430" x1="4152.75" y1="4260.4" x2="5160.79" y2="3178.32" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint15_linear_4698:34430" x1="3437.1" y1="4464.99" x2="5179.2" y2="2594.93" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint16_linear_4698:34430" x1="4129.9" y1="4238.77" x2="6453.8" y2="1744.18" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint17_linear_4698:34430" x1="4602.95" y1="4580.09" x2="5264.54" y2="3869.91" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint18_linear_4698:34430" x1="6123.7" y1="2797.32" x2="6950.76" y2="7206.67" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint19_linear_4698:34430" x1="6200.99" y1="3924.55" x2="6678.36" y2="6469.59" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint20_linear_4698:34430" x1="6065.27" y1="4684.48" x2="6317.94" y2="6031.52" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint21_linear_4698:34430" x1="5524.48" y1="4785.91" x2="5655.85" y2="5486.27" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint22_linear_4698:34430" x1="5452.36" y1="3646.09" x2="5936.73" y2="6228.44" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint23_linear_4698:34430" x1="5942.02" y1="3480.03" x2="6214.65" y2="4933.54" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint24_linear_4698:34430" x1="6202.09" y1="2782.61" x2="6673.26" y2="5294.6" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint25_linear_4698:34430" x1="5972.99" y1="3474.48" x2="6601.51" y2="6825.36" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint26_linear_4698:34430" x1="5417.52" y1="3652.63" x2="5596.46" y2="4606.59" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint27_linear_4698:34430" x1="3181.43" y1="6998.8" x2="7395.85" y2="6048.31" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint28_linear_4698:34430" x1="3810.56" y1="7335.68" x2="7135.58" y2="6585.78" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint29_linear_4698:34430" x1="3639.16" y1="6575.71" x2="4564.23" y2="6367.07" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint30_linear_4698:34430" x1="3577.63" y1="6226.38" x2="4474.58" y2="6024.09" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint31_linear_4698:34430" x1="3120.36" y1="6728.01" x2="7001.6" y2="5852.67" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint32_linear_4698:34430" x1="3650.42" y1="6625.64" x2="6642.27" y2="5950.88" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint33_linear_4698:34430" x1="3801.42" y1="7295.14" x2="4936.03" y2="7039.24" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint34_linear_4698:34430" x1="2633.14" y1="1064.2" x2="4755.04" y2="5016.92" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint35_linear_4698:34430" x1="3047.73" y1="2115.27" x2="4272.47" y2="4396.74" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint36_linear_4698:34430" x1="3148.2" y1="2880.65" x2="3796.44" y2="4088.19" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint37_linear_4698:34430" x1="2663.42" y1="3140.9" x2="3000.45" y2="3768.72" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint38_linear_4698:34430" x1="2249.94" y1="2076.27" x2="3492.64" y2="4391.19" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint39_linear_4698:34430" x1="2666.45" y1="1769.89" x2="3365.92" y2="3072.87" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint40_linear_4698:34430" x1="2703.41" y1="1026.48" x2="3912.25" y2="3278.32" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint41_linear_4698:34430" x1="2694.29" y1="1755.23" x2="4306.83" y2="4759.09" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint42_linear_4698:34430" x1="2218.72" y1="2093.03" x2="2677.79" y2="2948.2" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint43_linear_4698:34430" x1="3126.79" y1="2983.11" x2="6184.75" y2="-299.469" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint44_linear_4698:34430" x1="3988.16" y1="2251.9" x2="5753.19" y2="357.231" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint45_linear_4698:34430" x1="4680.32" y1="1910.12" x2="5614.52" y2="907.304" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint46_linear_4698:34430" x1="5082.92" y1="2285.16" x2="5568.63" y2="1763.78" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint47_linear_4698:34430" x1="4208.35" y1="3019.69" x2="5999.26" y2="1097.24" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint48_linear_4698:34430" x1="3784.09" y1="2724.15" x2="4792.12" y2="1642.07" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint49_linear_4698:34430" x1="3068.43" y1="2928.75" x2="4810.54" y2="1058.68" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint50_linear_4698:34430" x1="3761.24" y1="2702.52" x2="6085.13" y2="207.93" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint51_linear_4698:34430" x1="4234.29" y1="3043.85" x2="4895.88" y2="2333.66" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint52_linear_4698:34430" x1="1863.66" y1="5471.35" x2="625.816" y2="2463.13" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint53_linear_4698:34430" x1="1642.45" y1="4682.52" x2="927.976" y2="2946.2" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint54_linear_4698:34430" x1="1626.65" y1="4123" x2="1248.49" y2="3204" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint55_linear_4698:34430" x1="1995.6" y1="3971.19" x2="1798.99" y2="3493.38" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint56_linear_4698:34430" x1="2215.01" y1="4769.72" x2="1490.06" y2="3007.95" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint57_linear_4698:34430" x1="1891.89" y1="4959.87" x2="1483.85" y2="3968.23" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint58_linear_4698:34430" x1="1810.19" y1="5493.36" x2="1104.99" y2="3779.59" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint59_linear_4698:34430" x1="1870.73" y1="4968.38" x2="930.028" y2="2682.29" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint60_linear_4698:34430" x1="2238.77" y1="4759.94" x2="1970.96" y2="4109.11" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint61_linear_4698:34430" x1="7201.7" y1="864.428" x2="3377.7" y2="2694.07" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint62_linear_4698:34430" x1="6298.97" y1="1434.47" x2="4091.79" y2="2490.52" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint63_linear_4698:34430" x1="5795.18" y1="1961.99" x2="4626.97" y2="2520.94" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint64_linear_4698:34430" x1="6019.58" y1="2430.99" x2="5412.2" y2="2721.6" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint65_linear_4698:34430" x1="6929.04" y1="1849.99" x2="4689.51" y2="2921.52" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint66_linear_4698:34430" x1="6782.45" y1="1383.92" x2="5521.9" y2="1987.05" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint67_linear_4698:34430" x1="7169.17" y1="796.447" x2="4990.66" y2="1838.79" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint68_linear_4698:34430" x1="6769.41" y1="1357.2" x2="3863.37" y2="2747.64" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint69_linear_4698:34430" x1="6943.49" y1="1880.2" x2="6116.17" y2="2276.04" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint70_linear_4698:34430" x1="3133.29" y1="5723.35" x2="3321.55" y2="4567.6" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint71_linear_4698:34430" x1="3021.67" y1="5558.95" x2="3395.48" y2="3264.08" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint72_linear_4698:34430" x1="3869.5" y1="5306.84" x2="4143.73" y2="3623.28" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint73_linear_4698:34430" x1="4219.23" y1="4988.63" x2="4392.82" y2="3922.97" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint74_linear_4698:34430" x1="3908.4" y1="5963.33" x2="4303.96" y2="3534.96" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint75_linear_4698:34430" x1="3865.36" y1="5956.32" x2="4159.44" y2="4150.95" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint76_linear_4698:34430" x1="3242.3" y1="5854.83" x2="3461.08" y2="4511.68" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint77_linear_4698:34430" x1="3285.34" y1="5861.84" x2="3728.86" y2="3138.97" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint78_linear_4698:34430" x1="4327.95" y1="5006.34" x2="4425.47" y2="4407.67" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint79_linear_4698:34430" x1="6222.01" y1="4076.85" x2="6867.17" y2="1776.92" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint80_linear_4698:34430" x1="6150.64" y1="3230.47" x2="6499.19" y2="1987.92" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint81_linear_4698:34430" x1="6821.4" y1="3333.64" x2="7174.91" y2="2073.41" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint82_linear_4698:34430" x1="7228.73" y1="3347.6" x2="7447.26" y2="2568.55" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint83_linear_4698:34430" x1="6622.28" y1="3177.48" x2="6822.89" y2="2462.34" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint84_linear_4698:34430" x1="6401.83" y1="3115.64" x2="6668.96" y2="2163.37" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint85_linear_4698:34430" x1="7046.94" y1="3296.61" x2="7356.35" y2="2193.6" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint86_linear_4698:34430" x1="4239.62" y1="5208.9" x2="5642.05" y2="4842.38" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint87_linear_4698:34430" x1="4292.95" y1="4672.24" x2="5867.16" y2="4260.83" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint88_linear_4698:34430" x1="4538.54" y1="5467.26" x2="6052.85" y2="5071.5" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint89_linear_4698:34430" x1="4656.1" y1="5917.11" x2="5576.9" y2="5676.46" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint90_linear_4698:34430" x1="4290.61" y1="6236.78" x2="5252.85" y2="5985.3" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint91_linear_4698:34430" x1="4100.55" y1="5509.54" x2="5847.31" y2="5053.03" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint92_linear_4698:34430" x1="4060.9" y1="5357.84" x2="6285.65" y2="4776.41" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint93_linear_4698:34430" x1="4258.95" y1="6115.62" x2="5890.18" y2="5689.3" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint94_linear_4698:34430" x1="4725.34" y1="4831.15" x2="5681.28" y2="4581.32" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint95_linear_4698:34430" x1="2200.13" y1="3827.36" x2="610.588" y2="213.136" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint96_linear_4698:34430" x1="1794.28" y1="3007.65" x2="826.309" y2="806.736" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint97_linear_4698:34430" x1="1324.08" y1="2883.63" x2="562.295" y2="1151.52" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint98_linear_4698:34430" x1="787.942" y1="3119.43" x2="324.727" y2="2066.19" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint99_linear_4698:34430" x1="914.757" y1="3637.43" x2="94.1552" y2="1771.59" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint100_linear_4698:34430" x1="1813.34" y1="3976.85" x2="1023.08" y2="2179.99" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint101_linear_4698:34430" x1="2383.84" y1="3738.45" x2="1744.03" y2="2283.68" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint102_linear_4698:34430" x1="1844.25" y1="3963.26" x2="267.636" y2="378.437" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint103_linear_4698:34430" x1="827.73" y1="3675.7" x2="622.202" y2="3208.39" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint104_linear_4698:34430" x1="5069.41" y1="5681.64" x2="6222.55" y2="4167.81" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint105_linear_4698:34430" x1="6146.41" y1="5748.62" x2="6918.97" y2="4734.42" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint106_linear_4698:34430" x1="6205.63" y1="7268.37" x2="8311.53" y2="4503.77" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint107_linear_4698:34430" x1="6271.17" y1="7318.3" x2="7157.19" y2="6155.15" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint108_linear_4698:34430" x1="5602.77" y1="6809.15" x2="7043.61" y2="4917.64" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint109_linear_4698:34430" x1="5368.68" y1="5909.61" x2="6222.14" y2="4789.2" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint110_linear_4698:34430" x1="5564.75" y1="6780.19" x2="7538.64" y2="4188.91" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint111_linear_4698:34430" x1="5699.44" y1="5000.4" x2="5906.45" y2="4728.63" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint112_linear_4698:34430" x1="6723.8" y1="6143.99" x2="7592.36" y2="5003.76" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint113_linear_4698:34430" x1="3445.08" y1="1742.13" x2="871.929" y2="1376.07" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint114_linear_4698:34430" x1="3105.45" y1="1153.42" x2="1124.24" y2="871.58" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint115_linear_4698:34430" x1="3969.9" y1="912.035" x2="613.619" y2="434.575" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint116_linear_4698:34430" x1="3993.29" y1="747.593" x2="3011.67" y2="607.949" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint117_linear_4698:34430" x1="4081.35" y1="812.299" x2="3256.82" y2="695.003" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint118_linear_4698:34430" x1="4029.98" y1="1173.42" x2="3205.45" y2="1056.13" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint119_linear_4698:34430" x1="3365.82" y1="1909.93" x2="2911.71" y2="1845.33" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint120_linear_4698:34430" x1="4002.3" y1="1367.97" x2="594.323" y2="883.151" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint121_linear_4698:34430" x1="3953.17" y1="1713.33" x2="2572.66" y2="1516.94" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint122_linear_4698:34430" x1="3042.35" y1="5917.62" x2="1963.34" y2="8701.85" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint123_linear_4698:34430" x1="2295.22" y1="6144.53" x2="1464.43" y2="8288.26" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint124_linear_4698:34430" x1="2249.98" y1="5114.38" x2="842.565" y2="8745.98" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint125_linear_4698:34430" x1="2072.05" y1="5045.42" x2="1660.42" y2="6107.57" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint126_linear_4698:34430" x1="2167.36" y1="4963.72" x2="1821.61" y2="5855.88" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint127_linear_4698:34430" x1="2558.11" y1="5115.15" x2="2212.35" y2="6007.32" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint128_linear_4698:34430" x1="3209.51" y1="6049.97" x2="3019.09" y2="6541.32" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint129_linear_4698:34430" x1="2768.61" y1="5196.73" x2="1339.52" y2="8884.27" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint130_linear_4698:34430" x1="3142.3" y1="5341.55" x2="2563.4" y2="6835.3" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint131_linear_4698:34430" x1="2590.38" y1="1681.2" x2="1693.69" y2="2885.99" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint132_linear_4698:34430" x1="1739.87" y1="1637.82" x2="1139.13" y2="2444.98" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint133_linear_4698:34430" x1="1679.77" y1="439.028" x2="42.215" y2="2639.24" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint134_linear_4698:34430" x1="1627.61" y1="400.203" x2="938.636" y2="1325.9" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint135_linear_4698:34430" x1="2159.56" y1="796.122" x2="1039.16" y2="2301.48" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint136_linear_4698:34430" x1="2352.21" y1="1503.93" x2="1688.55" y2="2395.62" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint137_linear_4698:34430" x1="2189.81" y1="818.636" x2="654.913" y2="2880.91" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint138_linear_4698:34430" x1="2099.18" y1="2224.35" x2="1938.2" y2="2440.63" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      <linearGradient id="paint139_linear_4698:34430" x1="1280.74" y1="1330.9" x2="605.349" y2="2238.35" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FAFAFA" stop-opacity="0.5"/>
      <stop offset="0.505208" stop-color="#CAEFD0" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#FAFAFA" stop-opacity="0.5"/>
      </linearGradient>
      </defs>
    </svg>
  `
}

module.exports = origamiShape

