function select_article(article) {

  // replace img-url if present with selected version
  if (article.map_preview_image !== false) {

    let articleImg = article.map_preview_image
    let orientation = articleImg.width > articleImg.height ? 'landscape' : 'portrait'
    let img = {
      url: orientation === 'landscape'
        ? articleImg.sizes['map-selected-landscape']
        : articleImg.sizes['map-selected-portrait'],
      width: orientation === 'landscape'
        ? articleImg.sizes['map-selected-landscape-width'] /2
        : articleImg.sizes['map-selected-portrait-width'] /2,
      height: orientation === 'landscape'
        ? articleImg.sizes['map-selected-landscape-height'] /2
        : articleImg.sizes['map-selected-portrait-height'] /2,
    }

    article.html_element.style.width = `${img.width}px`
    article.html_element.children[0].children[0].style.height = `${img.height}px`

    article.html_element.children[0].classList.remove('pt0-5', 'pr0-5', 'pb0-5', 'pl0-5')

    article.html_element.children[0].classList.add('pt0-25', 'pr0-25', 'pb0-25', 'pl0-25')

  }

  article.html_element.classList.add('ts1-25',
                                     'pt0-5', 'pr0-5', 'pb0-5', 'pl0-5',
                                     'bs-bk',
                                     'bgc-light-gray-zwei',
                                     'ba1-5-black',
                                     'b-rad-5',
                                     'z4') 

}

function higlight_article_connections(article) {
  set_all_elements_to_lower_opacity()

  // highlight related ones
  article.html_element.classList.remove('op0-3')
  article.html_element.classList.add('op1', 'z5')

  article.svg_elements.forEach(line => {
    line.classList.remove('op0-3')
    line.classList.add('op1')
  })

  article.tags.forEach(tag => {
    tag.svg_elements[0].classList.remove('op0-3')
    tag.svg_elements[0].classList.add('op1')

    tag.html_element.classList.remove('op0-3')
    tag.html_element.classList.add('op1')
  })
}

function select_tag(tag) {

  const tag_html_gbr = tag.html_element.getBoundingClientRect()

  // html-layer
  const LABEL_OFFSET = 40
  const SCALED_UP_PADDING = 16 * 1.5
  tag.html_element.style.top = `${tag.map_location.y - (LABEL_OFFSET + SCALED_UP_PADDING)}px`
  

  tag.html_element.classList.remove('b-rad-2')
  tag.html_element.classList.add('ts1-25', 'trob',
                                 'bs-bk',
                                 'bgc-light-gray-zwei',
                                 'ba1-5-black',
                                 'b-rad-5',
                                 'z3') 

  // svg-layer
  const circleCx = tag.svg_elements[0].getAttribute('cx')
  const circleCy = tag.svg_elements[0].getAttribute('cy')
  const transformSVG = `translate(${Number(circleCx)} ${Number(circleCy)}) scale(1.5) translate(${Number(-circleCx)} ${Number(-circleCy)})`

  tag.svg_elements[0].setAttribute('transform', transformSVG)
  tag.svg_elements[0].classList.add('curp', 'z3')

}

function highlight_tag_connections(tag) {
  set_all_elements_to_lower_opacity()

  // Highlight related ones
  tag.html_element.classList.remove('op0-3')
  tag.html_element.classList.add('op1')

  tag.svg_elements[0].classList.remove('op0-3')
  tag.svg_elements[0].classList.add('op1')

  tag.svg_elements_lines.forEach(line => {
    line.classList.remove('op0-3')
    line.classList.add('op1')
  })

  tag.articles.forEach(article => {
    article.html_element.classList.remove('op0-3')
    article.html_element.classList.add('op1')
  })
}

function set_all_elements_to_lower_opacity() {
  // set all map-graph and map-ui nodes to lower opacity
  Array.from(document.querySelector('#svg-group-ui').children).map(child => {
    child.classList.add('op0-3')
  })

  Array.from(document.querySelector('#map-ui').children).map(child => {
    child.classList.add('op0-3')
  })
}

function clear_higlights(){
  Array.from(document.querySelector('#svg-group-ui').children).map(child => {
    child.classList.remove('op0-3', 'op1')
  })

  Array.from(document.querySelector('#map-ui').children).map(child => {
    child.classList.remove('op0-3', 'op1', 'z5')
  })
}

function getNodeColor(categories) {
  const colors = {
    'uncategorized': '#CAEFD0',
    'default': '#6A7880',
    'text': '#CAEFD0',
    'sound': '#583DC5',
    'mixed-media': '#FFD3E8',
    'reference': '#D3FAFF',
    'photo-video': '#FFFCE2',
    'contributor': '#FFE8D3',
    'keyword': '#6A7880',
  }

  const bgc = categories !== undefined
        ? colors[categories[0].slug]
        : colors['default'] 

  return bgc
}

module.exports = {select_article, select_tag,
                  higlight_article_connections, highlight_tag_connections, clear_higlights,
                  getNodeColor
                 }

