const sessionDB = require('../session-db')

function mapNodeReset(nodeSelected, keepSelectedBorder) {
  let db = sessionDB.getAll()
  
  let MAX_WIDTH = 330
  const node_gbr = nodeSelected.html_element.getBoundingClientRect()
  let htmlElement = nodeSelected.html_element

  if (nodeSelected.type === 'tag') {

    if (keepSelectedBorder) {
      htmlElement.classList.remove('bs-glow')
      htmlElement.classList.add('bs-bk')
    } else {

      // html-layer
      const LABEL_OFFSET = 40
      const PADDING = 8 * 1.5
      htmlElement.style.top  = `${nodeSelected.map_location.y - PADDING - LABEL_OFFSET}px`

      htmlElement.classList.remove('ts1-25', 'trob',
                                   'bgc-light-gray-zwei',
                                   'ba1-5-black',
                                   'b-rad-14',
                                   'bs-bk',
                                   'bs-glow',
                                   'z3')

      // svg-layer
      nodeSelected.svg_elements[0].removeAttribute('transform')
      nodeSelected.svg_elements[0].classList.remove('z3')
    }

  } else {

    // reset node-article
    if (keepSelectedBorder) {
      htmlElement.classList.remove('bs-glow')
      htmlElement.classList.add('bs-bk')
    } else {

      if (nodeSelected.map_preview_image !== false) {
        let articleImg = nodeSelected.map_preview_image
        let orientation = articleImg.width > articleImg.height ? 'landscape' : 'portrait'
        let img = {
          url: orientation === 'landscape'
            ? articleImg.sizes['map-selected-landscape']
            : articleImg.sizes['map-selected-portrait'],
          width: orientation === 'landscape'
            ? 190
            : 130,
          height: orientation === 'landscape'
            ? 130
            : 190,
        }

        MAX_WIDTH = img.width

        nodeSelected.html_element.style.width = `${img.width}px`
        nodeSelected.html_element.children[0].children[0].style.height = `${img.height}px`
      }

      htmlElement.classList.remove('ts1-25', 'trob',
                                   'pt0-5', 'pr0-5', 'pb0-5', 'pl0-5',
                                   'bgc-light-gray-zwei',
                                   'ba1-5-black',
                                   'b-rad-14',
                                   'bs-bk',
                                   'bs-glow',
                                   'z4')
    }

  }

  db.nodeSelected = {id: null, type: ''}
  sessionDB.save(db)

}

module.exports = mapNodeReset
