const html = require('nanohtml')
const raw = require('nanohtml/raw')
const {generate_article_event_handlers,
       generate_tag_event_handlers} = require("./interactions.js")

function create_html_layer(mapSize, tags, articles, isPreview) {
  const mapUI = document.querySelector('#map-ui')

  // create article boxes
  if (!isPreview) {
    articles.map(article => create_html_article_box(mapSize, mapUI, article, isPreview, articles, tags))
  }

  // create label for each tag
  tags.map(tag => create_html_tag_label(mapUI, mapSize, tag, isPreview, tags, articles))
}


// label for each tag
const LABEL_OFFSET = 40

function create_html_tag_label(mapUI, mapSize, tag, isPreview, tags, articles) {
  const {onClick, onHoverIn, onHoverOut} = generate_tag_event_handlers(tag, tags, articles, mapSize)

  const htmlElement = html`
    <div data-id=${tag.id}" data-type="keyword" class="droppable psa vh wsn oh curp usn tdn trop0-15 b-rad-2r pt0-5 pr0-5 pb0-5 pl0-5 sharp-text">
      <div class="fs-button-m bgc-lait-green fgc-white pr0-5 pl0-5 pb0-15 b-rad-2r ft-barlow">${tag.name}</div>
      <div class="dn psa"></div>
    </div>
  `

  if (!isPreview) {
    htmlElement.addEventListener('click', onClick)
    htmlElement.addEventListener('mouseover', onHoverIn)
    htmlElement.addEventListener('mouseout', onHoverOut)
  }

  mapUI.appendChild(htmlElement)

  // read boundingbox and then remove vh class
  let boundingBox = htmlElement.getBoundingClientRect()
  
  // set on screen width and height
  htmlElement.style.left = `${tag.map_location.x - boundingBox.width/2}px`
  htmlElement.style.top  = `${tag.map_location.y - LABEL_OFFSET}px`

  htmlElement.classList.remove('vh')

  // store htmlelement in tag data
  tag.html_element = htmlElement
}

// ARTICLE BOXES
let MAX_WIDTH = null

function create_html_article_box(mapSize, mapUI, article, isPreview, articles, tags) {
  // compute styles
  const iconStyle = article.categories !== undefined
        ? mapIconStyles(article.categories[0].slug, '1')
        : mapIconStyles('default', '1')

  // generate event handlers
  const {onClick,
         onHoverIn, onHoverOut,
         onMove,
         onMouseDown, onMouseUp
        } = generate_article_event_handlers(mapSize, article, articles, tags)

  // generate HTML code
  let htmlElement 

  if (article.map_preview_image !== false) {

    // image block
    let articleImg = article.map_preview_image
    let orientation = articleImg.width > articleImg.height ? 'landscape' : 'portrait'
    let img = {
      url: orientation === 'landscape'
        ? articleImg.sizes['map-selected-landscape']
        : articleImg.sizes['map-selected-portrait'],
      width: orientation === 'landscape'
        ? 190
        : 130,
      height: orientation === 'landscape'
        ? 130
        : 190,
    }

    MAX_WIDTH = img.width

    htmlElement = html`
      <div data-id="${article.id}" data-type="post" class="droppable psa vh curp sharp-text">
       <div class="psr z1 pt0-25 pr0-25 pb0-25 pl0-25 b-rad-2 ${iconStyle}">
         <div data-type="post-inner" style="background-image: url(${img.url}); height: ${img.height}px;" class="node-img-cover trop0-15 usn"></div>
        </div>
        ${preview()}
      </div>
    `
  } else if (article.map_preview_text !== '') {
    // text block w/ map-preview text

    MAX_WIDTH = 330

    htmlElement = html`
      <div data-id="${article.id}" data-type="post" class="droppable psa vh z1 curp sharp-text">
        <div data-type="post-inner" class="psr fgc-black usn tdn tac pt0-25 pr0-5 pb0-5 pl0-5 fs-map-md-small trop0-15 b-rad-2 ${iconStyle}">${article.map_preview_text}</div>
        ${preview()}
      </div>
    `
  } else {

    MAX_WIDTH = 330

    // text block using article's title
    htmlElement = html`
      <div data-id="${article.id}" data-type="post" class="droppable psa vh z1 curp sharp-text">
        <div data-type="post-inner" class="psr fgc-black usn tdn tac pt0-25 pr0-5 pb0-5 pl0-5 fs-map-md-small trop0-15 b-rad-2 ${iconStyle}">${article.title}</div>
        ${preview()}
      </div>
    `
  }

  function preview() {
    return html`
      <div class="node-preview pen usn op0 trop0-25 psa bgc-black fgc-white fs-node-preview ft-barlow pt0-1 pr0-25 pb0-25 pl0-25 b-rad-3 z3 sharp-text">${raw(article.excerpt)}</div>
    `
  }

  if (!isPreview) {
    htmlElement.addEventListener('mousedown', onMouseDown)
    htmlElement.addEventListener('mouseup', onMouseUp)

    htmlElement.addEventListener('mouseover', onHoverIn)
    htmlElement.addEventListener('mouseleave', onHoverOut)

    htmlElement.addEventListener('mousemove', onMove)
  }

  // position block on screen
  mapUI.appendChild(htmlElement)
  htmlElement.style.width = `${MAX_WIDTH}px`

  let boundingBox = htmlElement.getBoundingClientRect()
  htmlElement.style.left = `${article.map_location.x - boundingBox.width/2}px`
  htmlElement.style.top  = `${article.map_location.y - boundingBox.height/2}px`

  htmlElement.classList.remove('vh')

  // store htmlElement in article data
  article.html_element = htmlElement
}

function mapIconStyles(category, border) {
  const icons = {
    'uncategorized': `ba${border}-dark-green bgc-pistachio`,
    'default': `ba${border}-dark-green bgc-pistachio`,
    'text': `ba${border}-dark-green bgc-pistachio`,
    'sound': `ba${border}-purple bgc-light-gray`,
    'mixed-media': `ba${border}-orange bgc-pink`,
    'reference': `ba${border}-lait-green bgc-green`,
    'photo-video': `ba${border}-salmon bgc-yellow`,
    'contributor': `ba${border}-salmon `,
    'keyword': `fgc-white tdn bgc-lait-green bgc-black-hv pr0-5 pl0-5 pb0-15 mr0-7 b-rad-2r ft-barlow`,
  }

  return icons[category]
}

module.exports = {create_html_layer, create_html_tag_label}
