function compute_force_directed_layout(articles, selected_nodes){
  // Repeat the proces until it stabilises
  for (let index = 0; index < 100; index++) {

    // Compute Spring for each article and connected tags
    for (let i = 0; i < articles.length; i++) {
      let article = articles[i]
      for (let j = 0; j < article.tags.length; j++) {
        let tag = article.tags[j]
        let force = article.tags_force[j] / 10

        if (!selected_nodes.includes(article.id)) {
          article.map_location = apply_hookes_law(article.map_location, tag.map_location, force)
        }

        tag.map_location = apply_hookes_law(tag.map_location, article.map_location, force)
      }
    }

    // Compute Repulsion for each pair of articles
    for (let i = 0; i < articles.length; i++) {
      for (let j = i+1; j < articles.length; j++) {
        if (!selected_nodes.includes(articles[i].id) && !selected_nodes.includes(articles[j].id)) {
          let new_locations = apply_coulombs_law(articles[i].map_location, articles[j].map_location)

          articles[i].map_location = new_locations.node_A
          articles[j].map_location = new_locations.node_B
        }
      }
    }
  }
}


//This makes sure boxes are attracted towards connected label nodes by modeling each edge as a spring
//Hookes law describes the physics of a spring, the offset is used
const SPRING_LENGTH = 200 //The distance articles should keep from the tag nodes  
const SPRING_STIFFNESS = 0.1 //The 'springyness' of the spring
function apply_hookes_law(movable_node, fixed_node, offset_force){
  let vec = movable_node.subtract(fixed_node)
  let displacement = SPRING_LENGTH - vec.magnitude() 
  let direction = vec.normalize()
  let force = direction.scale(SPRING_STIFFNESS * offset_force * displacement * 0.5)

  //apply the force to the movable_node
  return movable_node.add(force)
}


// This makes sure boxes don't overlap each other, if they come too close they will push each other away 
// Coulombs law models the physics of two electrically charged particles using an inverse square law
// The force becomes weaker as the particles move further away from each other
const REPULSION = 3000000 //Amount of repulsion between particles/nodes
function apply_coulombs_law(node_A, node_B){
  let vec = node_A.subtract(node_B)
  let distance = vec.magnitude() + 0.1 // avoid massive forces at small distances (and divide by zero)
  let distance_squared = distance*distance
  let direction = vec.normalize()

  let force_A = direction.scale(REPULSION).scale(1/(distance_squared*0.5))
  let force_B = direction.scale(REPULSION).scale(1/(distance_squared*-0.5))

  //Apply force to each point
  return {
    node_A: node_A.add(force_A),
    node_B: node_B.add(force_B)
  }
    
}

module.exports = compute_force_directed_layout
