// tags
async function fetch_tags(isPreview, query){
  let tags = require('../../tags.json')

  // map locations to ear vectors 
  // sort by ID ASC order
  tags = tags.map(transform_tag).sort((a, b) => {
    return a.id - b.id;
  })

  return tags
}

function transform_tag (t) {
  t.type = "tag"
  t.map_location = ear.vector(t.map_location[0], t.map_location[1])
  t.html_element = null
  t.svg_elements = []
  t.svg_elements_lines = []
  t.articles = []
  return t
} 

// articles
async function fetch_articles(tags, query){
  let articles = require('../../posts.json')
  articles = articles.map((article) => {
    let new_article = {
      id: article.id,
      title: article.title.rendered,
      slug: article.slug,
      contributor: article.contributor.length > 0 ? article.contributor : [],
      excerpt: article.excerpt.rendered,
      date: article.date,
      type: article.type,
      format: article.format,
      categories: 'wp:term' in article._embedded
        ? article._embedded['wp:term'][0]
        : article.categories,
      image: 'wp:featuredmedia' in article._embedded
        ? article._embedded['wp:featuredmedia'][0]
        : null,
      map_preview_image: article.map_preview_image,
      map_preview_text: article.map_preview_text,
      count: 0,
      map_location: ear.vector(Number(article.post_location.position_x),
                               Number(article.post_location.position_y)),
      html_element: null,
      svg_elements: [],
    }

    // lookup tag objects and link articles and tags
    new_article.tags = article._embedded['wp:term'][1].map(tag => {
      let new_tag = tags.find(t => t.id === tag.id)
      new_tag.articles.push(new_article)
      return new_tag
    })

    // sort post forces to match tag order
    new_article.tags_force = []
    new_article.tags.forEach(tag=>{
      if (article.post_attraction !== null) {
        let attraction = article.post_attraction.find(pl=>pl.keyword == tag.id).attraction
        new_article.tags_force.push(Number(attraction))
      }
    })

    return new_article
  })

  return articles
}

async function WPpagination(fetchURL) {
  let WPdata = []
  let pageIdx = 1

  let initURL = `${fetchURL}&page=${pageIdx}`
  let posts_response = await fetch(initURL)
      .catch(err => {
        console.log('wp-pagination, post-response err =>', err)
      })

  let WPtotal = Number(posts_response.headers.get('X-WP-Total'))
  let WPtotalPages = Number(posts_response.headers.get('X-WP-TotalPages'))

  let posts = await posts_response.json()
  posts.forEach(post => WPdata.push(post))

  if (WPtotalPages > pageIdx) {
    for (let i = pageIdx; i <= WPtotalPages+1; i++) {
      pageIdx++
      let newURL = `${fetchURL}&page=${pageIdx}`
      let posts_response = await fetch(newURL)
          .catch(err => {
            console.log('err =>', err)
          }) 

      let posts = await posts_response.json()
      posts.forEach(post => WPdata.push(post))
    }
  }

  return WPdata

}

module.exports = {fetch_articles, fetch_tags, transform_tag, WPpagination}
