"use strict";

const html = require('nanohtml')
const {mapListBoxAppend} = require('./map-list-box')
const sessionDB = require('./session-db')

// pass svg point position
// keep in sync with svg point when this moves
// or the map moves
function mapUITag(data) {

  if (data !== null) {
    const node = document.querySelector(`.circle-${data.id}`)
    const nodeGBR = node.getBoundingClientRect()

    const tag = html`
      <div data-id=${data.id}" data-type="keyword" onclick=${onClick} onmouseover=${onHoverIn} onmouseout=${onHoverOut} class="psa vh z1 curp usn tdn">
        <div class="fgc-white bgc-lait-green bgc-black-hv pr0-5 pl0-5 pb0-15 b-rad-2r ft-barlow">${data.name}</div>
        <div class="dn psa"></div>
      </div>
    ` 

    // we set tag to .vh, append it to DOM
    // fetch width, and remove .vh
    const mapUI = document.querySelector('#map-ui')
    mapUI.appendChild(tag)

    // vertically center tag, and offset it horizontally to be double the height of the tag-label (so dot is visible)
    const tagGBR = tag.getBoundingClientRect()
    tag.style.top = `${nodeGBR.top - (nodeGBR.height / 2) - tagGBR.height}px`
    tag.style.left = `${nodeGBR.left + (nodeGBR.width / 2) - (tagGBR.width / 2)}px`

    tag.style.width = `${tagGBR.width}px`
    tag.children[0].style.width = `${tagGBR.width}px`

    tag.classList.remove('vh')

    // --- events
    const circle = document.querySelector(`circle[data-id='${data.id}']`)
    circle.addEventListener('click', onClick)
    
    async function onClick (e) {
      // -- scale up tag node
      let t
      if (e.target.nodeName === 'circle'
          || e.target.nodeName === 'DIV' && Object.keys(e.target.dataset).length > 0) {
        t = e.target
      } else {
        t = e.target.parentNode
      }

      const circleCx = circle.getAttribute('cx')
      const circleCy = circle.getAttribute('cy')
      const transformSVG = `translate(${circleCx} ${circleCy}) scale(1.5) translate(-${circleCx} -${circleCy})`

      const circleGBR = circle.getBoundingClientRect()
      const transformCSS = `scale(1.5) translateY(-${circleGBR.height /2}px)`

      if (t.nodeName === 'DIV') {
        t.style.transform = transformCSS
        t.style.width = `${tagGBR.width + 16}px` // +1rem (0.5 left, 0.5 right) 
        t.style.height = `${ circleGBR.bottom - t.getBoundingClientRect().top + 16}px` 
        t.style.padding = '0.5rem'
        t.style.backgroundColor = '#F4F6EF'
        t.style.border = '1.5px solid #212121'
        t.style.borderRadius = '14px'

        t.classList.add('z2')

        circle.setAttribute('transform', transformSVG)

      } else if (t.nodeName === 'circle') {
        t.setAttribute('transform', transformSVG)

        tag.style.transform = transformCSS
        tag.style.width = `${tagGBR.width + 16}px` // +1rem (0.5 left, 0.5 right) 
        tag.style.height = `${ circleGBR.bottom - tag.getBoundingClientRect().top}px` 

        tag.classList.add('z2', 'pt0-5', 'pr0-5', 'pb0-5', 'pl0-5', 'ba1-5-black', 'b-rad-14', 'bgc-ot-light-gray')
      }

      // save selected node's id to session-db
      // (for less DOM traversing?)
      let db = sessionDB.getAll()
      db.nodeSelected = {id: Number(t.dataset.id), type: 'tag'}
      sessionDB.save(db)

      // --
      
      const mapResultBox = document.querySelector('#map-result-box')
      if (mapResultBox === null) {
        return
      }
      
      const point = { title: data.name,
                      slug: data.slug,
                      type: 'tag',
                      id: data.id }

      mapListBoxAppend(e, point, mapResultBox)
    }

    // set `onmouseover` and `onmouseleave` to `svg.circle`
    // connected the current map-ui-tag.dataset.id
    circle.addEventListener('mouseover', onHoverIn)
    circle.addEventListener('mouseout', onHoverOut)

    // -- on hover: nearest connections remain highlighted
    function onHoverIn (e) {
      let t
      if (e.target.nodeName === 'circle'
          || e.target.nodeName === 'DIV' && Object.keys(e.target.dataset).length > 0) {
        t = e.target
      } else {
        t = e.target.parentNode
      }

      highlightNearestConnection(t)
    }

    function highlightNearestConnection(t) {
      // picks post w/ highest tag's attraction value
      const keywordID = Number(t.dataset.id)
      
      // set all map-graph and map-ui nodes to lower opacity
      // except hovering node (tag-group [circle, div])
      Array.from(document.querySelector('#map-graph > svg').children[0].children)
        .filter(child => Number(child.dataset.id) !== keywordID)
        .map(child => child.classList.add('op0-3'))

      Array.from(document.querySelector('#map-ui').children)
        .filter(child => Number(child.dataset.id) !== keywordID)
        .map(child => child.classList.add('op0-3'))
      
      // build nearest-connection list of post
      const posts = Array.from(document.querySelectorAll("[data-vertices]"))
      const nearestConnections = posts.filter(post => {
        const vertices = post.dataset.vertices.split(' ').map(id => Number(id))
        if (vertices.includes(keywordID)) {
          return post
        }
      })
    }

    function onHoverOut () {
      // -- set all map-graph and map-ui nodes to normal opacity
      let db = sessionDB.getAll()
      console.log('hover-out =>', db.nodeSelected)
      if (db.nodeSelected.id !== null) {
        return
      }

      // remove opacity from all nodes
      Array.from(document.querySelector('#map-graph > svg').children[0].children).map(child => {
        child.classList.remove('op0-3', 'op1')
      })

      Array.from(document.querySelector('#map-ui').children).map(child => {
        child.classList.remove('op0-3', 'op1')
      })
    }

  }

}

module.exports = mapUITag
