"use strict";

const html = require('nanohtml')
const {mapListBoxAppend} = require('./map-list-box')
const sessionDB = require('./session-db')

// pass svg point position
// keep in sync with svg point when this moves
// or the map moves
function mapUIPost(data) {

  // arbitraty max-width in px (21rem)
  const MAX_WIDTH = 336 

  // check if category is Undefined (id: 1)
  if (data !== null && data.categories[0] !== 1) {

    const node = document.querySelector(`.circle-${data.id}`)
    const nodeGBR = node.getBoundingClientRect()

    const category = data.categories[0] !== undefined
          ? data.categories[0].slug
          : 'default'

    const borderStyles = {
      "default": 'ba1-dark-green',
      "text": 'ba1-dark-green',
      "photo-video": 'ba1-salmon',
      "reference": 'ba1-lait-green',
      "sound": 'ba1-purple',
    }

    const postVertices = data.tags.map(tag => tag.id)
    const postVerticesLabel = postVertices.join(' ')

    let post
    if (data.categories[0] === 37 && data.image !== null) {

      const ratio = data.image.media_details.width / MAX_WIDTH

      post = html`
        <div data-id="${data.id}" data-vertices="${postVerticesLabel}" data-type="post" onmouseover=${onHoverIn} onmouseout=${onHoverOut} style="background-image: url(${data.image.source_url}); background-repeat: no-repeat; background-attachment: scroll; background-size: ${MAX_WIDTH}px; min-height: ${data.image.media_details.height / ratio}px;" class="${borderStyles} psa vh z1 curp usn pt0-5 pr0-5 pb0-5 pl0-5 b-rad-2 eio0-25"></div>
      `

    } else {

      post = html`
        <div data-id="${data.id}" data-vertices="${postVerticesLabel}" data-type="post" onmouseover=${onHoverIn} onmouseout=${onHoverOut} class="${borderStyles} psa vh z1 curp fgc-black usn tdn tac pt0-5 pr0-5 pb0-5 pl0-5 b-rad-2 fs-map-md-small eio0-25">${data.title}</div>
      `
    }

    // we set post to .vh, append it to DOM
    // fetch width, and remove .vh
    const mapUI = document.querySelector('#map-ui')
    mapUI.appendChild(post)

    // get node's center by substracting half of node.height to node.top
    // then center post by substracting half of its height too
    const postGBR = post.getBoundingClientRect()
    post.style.top = `${nodeGBR.top}px`
    post.style.left = `${nodeGBR.left + (nodeGBR.width / 2) - (postGBR.width / 2)}px`
    post.style.width = `${MAX_WIDTH}px` 

    post.classList.remove('vh')
    const mapResultBox = document.querySelector('#map-result-box')

    post.addEventListener('click', async(e) => {
      const t = e.target

      t.classList.add('bs-bk', 'z2')

      // -- scale-up animation
      const transformCSS = `scale(1.5)`
      t.style.transform = transformCSS

      // save selected node's id to session-db
      // (for less DOM traversing?)
      let db = sessionDB.getAll()
      db.nodeSelected = {id: Number(t.dataset.id), type: 'post'}
      sessionDB.save(db)
      // --

      mapListBoxAppend(e, data, mapResultBox, false)
    })

    // -- on hover: nearest connections remain highlighted
    function onHoverIn (e) {
      highlightNearestConnection()
    }

    function highlightNearestConnection() {
      // picks post w/ highest tag's attraction value
      const keywordID = data.post_location.reduce((prev, current) => {
        return (prev.attraction > current.attraction) ? prev : current
      }).keyword
      
      // set all map-graph and map-ui nodes to lower opacity
      Array.from(document.querySelector('#map-graph > svg').children).map(child => {
        child.classList.add('op0-3')
      })

      Array.from(document.querySelector('#map-ui').children).map(child => {
        child.classList.add('op0-3')
      }) 

      // build nearest-connection list of post
      const posts = Array.from(document.querySelectorAll("[data-vertices]"))
      const nearestConnections = posts.filter(post => {
        const vertices = post.dataset.vertices.split(' ').map(id => Number(id))
        if (vertices.includes(keywordID)) {
          return post
        }
      })

      // grab tag label and circle used to build nearest-connection list
      const tagNodeGroup = Array.from(document.querySelectorAll(`[data-id='${keywordID}']`))

      // make both tagNodeGroup and nearestConnections fully visible
      tagNodeGroup.map(item => {
        item.classList.remove('op0-3')
        item.classList.add('op1')
      })
      nearestConnections.map(item => {
        item.classList.remove('op0-3')
        item.classList.add('op1')
      })
    }

    function onHoverOut (e) {
      // -- set all map-graph and map-ui nodes to normal opacity
      let db = sessionDB.getAll()
      console.log('hover-out =>', db.nodeSelected)
      if (db.nodeSelected.id !== null) {
        return
      }

      Array.from(document.querySelector('#map-graph > svg').children).map(child => {
        child.classList.remove('op0-3', 'op1')
      })

      Array.from(document.querySelector('#map-ui').children).map(child => {
        child.classList.remove('op0-3', 'op1')
      })
    }


  }

}

module.exports = mapUIPost
