"use strict";

function mapUILocationSync() {
  // sync all map-UI nodes with map-graph nodes new position
  // (eg when zooming and panning)

  const nodes = Array.from(document.querySelectorAll(`.node-map`))

  nodes.map(node => {
    const nodeGBR = node.getBoundingClientRect()

    const element = document.querySelector(`[data-id='${node.dataset.id}']`)
    const elementGBR = element.getBoundingClientRect()

    element.style.top = element.dataset.type === 'tag'
      ? `${nodeGBR.top - (nodeGBR.height / 2) - elementGBR.height}px`
      : `${nodeGBR.top}px`
    element.style.left = `${nodeGBR.left + (nodeGBR.width / 2) -  (elementGBR.width / 2)}px`

  })

}

module.exports = mapUILocationSync
