const localDB = require('./local-db')
const sessionDB = require('./session-db')
const {fetch_articles, fetch_tags} = require('./map/fetch-data')
const {mapListBox} = require('./map-list-box')
const mapListEdit = require('./map-list-edit')
const scrollLock = require('./scroll-lock')

function mapNavToggle() {
  const target = document.querySelector('#map-nav-toggle')
  target.addEventListener('click', toggleMenu)

  mapNavNotify()
}

function toggleMenu() {
  // display mobile-logo, view toggle, map-list
  let sessiondb = sessionDB.getAll()

  const menuClose = document.querySelector('#map-menu-close')
  const menuOpen = document.querySelector('#map-menu-open')
  const menuPlus = document.querySelector('#map-menu-plus')

  const mapList = document.querySelector('#map-result-box')
  let mapResulList = document.querySelector('#map-result-list')
  let listBox = document.querySelector('.map-list-box')
  const mapListBG = document.querySelector('#map-list-bg')

  const footerMain = Array.from(document.querySelectorAll('.footer-main'))
  const mapToggleMessage = document.querySelector('#map-toggle-message')
  const zoomControl = document.querySelector('#zoom-control')

  let scrollY

  let localdb = localDB.getAll()
  if (localdb.helpText) {
    let mapHelp = document.querySelector('#map-help')
    mapHelp.classList.remove('x')
    mapHelp.classList.add('dn')

    mapList.classList.remove('map-help')
    listBox.classList.remove('map-help')

    localdb.helpText = false
    localDB.save(localdb)
  }

  // map-list open
  if (menuOpen.classList.contains('dn')) {
    // check if mapList has any item before opening,
    if (sessiondb.articles.length > 0) {
      mapListBG.classList.remove('dn')
      menuClose.classList.add('dn')
      menuOpen.classList.remove('dn')

      if (zoomControl !== null) {
        zoomControl.parentNode.classList.add('w24p', 'h24p')
        zoomControl.classList.remove('x')
        zoomControl.classList.add('dn')
      }

      footerMain.map(item => item.classList.remove('dn'))

      mapList.classList.remove('dn')
      mapList.focus()

      scrollLock(1)
      scrollY = window.scrollY

      menuPlus.classList.add('dn')

    } else {
      // show black-label message
      mapToggleMessage.innerText = 'No Reader selection yet!'
      mapToggleMessage.classList.remove('dn')
    }

  } else {
    // map-list close

    // reset map-list edit-mode
    mapListEdit({target: null, action: 'reset'})
    
    menuOpen.classList.add('dn')
    menuClose.classList.remove('dn')

    if (zoomControl !== null) {
      zoomControl.parentNode.classList.remove('w24p', 'h24p')
      zoomControl.classList.remove('dn')
      zoomControl.classList.add('x')
    }

    if (sessiondb.articles.length > 0) {
      footerMain.map(item => item.classList.add('dn'))

      mapListBG.classList.add('dn')
      mapList.classList.add('dn')
      mapList.blur()

      scrollLock(0)

      window.scrollTo(0, scrollY)

      menuPlus.classList.remove('dn')

    } else {
      // hide black-label message
      mapToggleMessage.innerText = ''
      mapToggleMessage.classList.add('dn')
    }
  }
}

function mapNavNotify() {
  let sessiondb = sessionDB.getAll()
  const menuClose = document.querySelector('#map-menu-close')
  const menuOpen = document.querySelector('#map-menu-open')
  const menuPlus = document.querySelector('#map-menu-plus')
  const mapToggleMessage = document.querySelector('#map-toggle-message')

  if (sessiondb.articles.length > 0) {
    menuClose.classList.add('dn')
    menuPlus.classList.remove('dn')

    // if menu is open, when adding new item close it
    if (!menuOpen.classList.contains('dn')) {
      menuOpen.classList.add('dn')
    }

    mapToggleMessage.innerText = ''
    mapToggleMessage.classList.add('dn')

  } else {
    if (menuClose.classList.contains('dn')) {
      menuPlus.classList.add('dn')
      menuClose.classList.remove('dn')

    }
  }

}

function viewToggle() {
  const map = document.querySelector('#scm-toggle-main')
  const reader = document.querySelector('#scm-toggle-reader')

  const edit = document.querySelector('#scm-edit')
  const restart = document.querySelector('#scm-restart')

  map.addEventListener('click', (e) => {
    map.classList.add('bgc-white')
    reader.classList.remove('bgc-white')

    edit.classList.remove('dn')
    restart.classList.remove('dn')
  })

  reader.addEventListener('click', (e) => {
    map.classList.remove('bgc-white')
    reader.classList.add('bgc-white')

    edit.classList.add('dn')
    restart.classList.add('dn')
  })

}

module.exports = {mapNavToggle, toggleMenu, mapNavNotify, viewToggle}
