"use strict";

const sessionDB = require('./session-db')
const mapNodeReset = require('./map/map-node-reset')
const {mapListBox} = require('./map-list-box')
const updateSplitReader = require('./map/split-reader-update')

function mapListUndo(articles, tags) {
  const mapResultBox = document.querySelector('#map-result-box')
  const mapResultList = mapResultBox.querySelector('#map-result-list')
  const splitBox = document.querySelector('#split-box')

  const nodesRemoved = sessionDB.removeLast()
  nodesRemoved.map(node => {
    const nodeSelected = node.type === 'post'
          ? articles.find(art => art.id === node.id)
          : tags.find(tag => tag.id === node.id)

    mapNodeReset(nodeSelected, false)
  })

  Array.from(mapResultList.children).map(child => child.remove())
  mapListBox(articles, tags, false, false)

  updateSplitReader(tags, articles)
}

module.exports = mapListUndo
