"use strict";

const sessionDB = require('./session-db')
const crypto = require('crypto')

function mapListLink(e, context) {
  
  // const btn = e.target.parentNode.parentNode.parentNode
  const btn = e.target.type === 'button'
        ? e.target 
        : e.target.parentNode.parentNode.parentNode
  const mapResultLink = btn.previousElementSibling

  generateLink(btn, mapResultLink, context)
}

function generateLink(btn, mapResultLink, context) {
  // generate link

  if (context[0] === 'reader') {

    if (sessionDB.exists()) {
      let db = sessionDB.getAll()

      if (db.articles.length > 0) {
        const URLResult = generateURL()

        const listURL = URLResult.url
        const URLhash = URLResult.hash

        db.url = listURL
        db.hash = URLhash
        sessionDB.save(db)

        // copy URL to OS clipboard
        copyToClipboardandHide(listURL, mapResultLink)
          .then(() => {
            mapResultLink.classList.remove('dn')

            setTimeout(() => {
              mapResultLink.classList.add('dn')
            }, 3000)

          })
          .catch((err) => {
            console.lg('error!', err)

            mapResultLink.textContent = "An error happened, try again"
            mapResultLink.classList.remove('dn')

            setTimeout(() => {
              mapResultLink.classList.add('dn')
            }, 3000)

          })

      } else {

        mapResultLink.textContent = "Nothing to share yet!"
        mapResultLink.classList.remove('dn')

        setTimeout(() => {
          mapResultLink.classList.add('dn')
        }, 3000)

      }

    } else {

      mapResultLink.textContent = "Nothing to share yet!"
      mapResultLink.classList.remove('dn')

      setTimeout(() => {
        mapResultLink.classList.add('dn')
      }, 3000)

    }

  } else if (context[0] === 'page') {

    const pageURL = context[1]
    // window.location 

    // copy URL to OS clipboard
    copyToClipboardandHide(pageURL, mapResultLink)
      .then(() => {
        mapResultLink.classList.remove('dn')

        setTimeout(() => {
          mapResultLink.classList.add('dn')
        }, 3000)

      })
      .catch((err) => {
        console.lg('error!', err)

        mapResultLink.textContent = "An error happened, try again"
        mapResultLink.classList.remove('dn')

        setTimeout(() => {
          mapResultLink.classList.add('dn')
        }, 3000)
      })

    mapResultLink.classList.remove('dn')

    setTimeout(() => {
      mapResultLink.classList.add('dn')
    }, 3000)

  }
}

function generateURL() {
  let db = sessionDB.getAll()

  const articleList = db.articles.map(article => article.id).join('.')     
  const articleListURL = `${window.location.hostname}/reader/?id=${articleList}`
  const URLhash = crypto.createHash('sha256').update(articleListURL).digest('hex')

  return {
    url: articleListURL,
    hash: URLhash
  }
}

// <https://stackoverflow.com/a/65996386>
function copyToClipboardandHide (text, element) {
  if (navigator.clipboard && window.isSecureContext) {
    return navigator.clipboard.writeText(text)
  } else {
    let textarea = document.createElement('textarea')
    textarea.value = text
    textarea.style.position = 'fixed'
    textarea.style.left = '-999999px'
    textarea.style.top = '-999999px'
    document.body.appendChild(textarea)

    textarea.focus()
    textarea.select()
    textarea.setSelectionRange(0, 99999); /* For mobile devices */

    return new Promise((res, rej) => {
      // here the magic happens
      document.execCommand('copy') ? res() : rej();
      textarea.remove();
    });

  }
}

module.exports = {
  mapListLink: mapListLink,
  generateLink: generateLink,
  generateURL: generateURL
}
