function mapListEdit(input) {
  // on small screens: display delete button
  // next to each item on the list
  // change label Edit => Done

  const label = document.querySelector('#scm-edit')
  const mapListItems = Array.from(document.querySelector('#map-result-list').children)

  if (input.target === null) {
    // if map-list-box open, keep close button visible
    // else reset edit-mode state
    if (input.action === 'reset') {
      label.innerText = 'Edit'

      mapListItems.map(item => {
        let btn = item.querySelector('.item-delete')
        if (btn !== null) {
          btn.classList.add('dn')
        }
      })
    
    } else if (input.action === 'edit') {
      mapListItems.map(item => {
        let btn = item.querySelector('.item-delete')
        if (btn !== null) {
          btn.classList.remove('dn')
        }
      })
    }

  } else { 

    if (label.innerText === 'Edit') {
      label.innerText = 'Done'

      mapListItems.map(item => {
        let btn = item.querySelector('.item-delete')
        if (btn !== null) {
          btn.classList.remove('dn')
        }
      })

    } else {
      label.innerText = 'Edit'

      mapListItems.map(item => {
        let btn = item.querySelector('.item-delete')
        if (btn !== null) {
          btn.classList.add('dn')
        }
      })
    }
  }

}

module.exports = mapListEdit
