"use strict";

const {mapListBox} = require('./map-list-box')

function mapListClose(e, articles, tags) {
  const mapResultBox = document.querySelector('#map-result-box')
  const mapResultWrap = mapResultBox.querySelector('.collapsible-wrapper')
  const mapResultFooter = mapResultBox.querySelector('footer')
  let mapResultList = document.querySelector('#map-result-list')

  mapResultWrap.classList.toggle('collapsed')

  let t = null
  let target = e.target !== undefined ? e.target : e
  if (target.nodeName === 'svg') {
   t = target.parentNode.parentNode
  } else if (target.nodeName === 'path' || target.nodeName === 'circle') {
    t = target.parentNode.parentNode.parentNode
  } else if (target.nodeName === 'SPAN') {
    t = target.parentNode
  } else if (target.nodeName === 'BUTTON') {
    t = target
  }

  // swap icon ^ / v
  if (mapResultWrap.classList.contains('collapsed')) {
    t.children[0].classList.remove('db')
    t.children[0].classList.add('dn')
    
    t.children[1].classList.remove('dn')
    t.children[1].classList.add('db') 

  } else {
    t.children[0].classList.remove('dn')
    t.children[0].classList.add('db')

    t.children[1].classList.remove('db')
    t.children[1].classList.add('dn')

    Array.from(mapResultList.children).map(child => child.remove())
    mapListBox(articles, tags, false, false)

  }
 
}

module.exports = mapListClose
