"use strict";

const sessionDB = require('./session-db')
const mapNodeReset = require('./map/map-node-reset')

function mapListClear(e, articles, tags) {
  const mapResultBox = document.querySelector('#map-result-box')
  const mapResultList = mapResultBox.querySelector('#map-result-list')
  const splitBox = document.querySelector('#split-box')

  let db = sessionDB.getAll()

  // clear selected nodes in map
  db.articles.map(node => {
    const selectedNode = node !== undefined && node.type === 'post'
          ? articles.find(article => article.id === node.id)
          : tags.find(tag => tag.id === node.id)

    mapNodeReset(selectedNode, false)
  })

  // clear list from map-list-box
  Array.from(mapResultList.children).forEach(item => {
    item.remove()
  })

  // clear items and close split-screen reader (if box is open)
  if (!splitBox.classList.contains('dn')) {
    const splitBoxList = splitBox.querySelector('#split-box-list')

    if (splitBoxList !== null) {
      Array.from(splitBoxList.children).forEach(item => {
        item.remove()
      })

    }

    splitBox.classList.add('dn')
  }

  // small-screen: close menu
  const menuClose = document.querySelector('#map-menu-close')
  const menuOpen = document.querySelector('#map-menu-open')
  const menuPlus = document.querySelector('#map-menu-plus')
  const viewToggle = document.querySelector('#view-toggle')
  const maplistBG = document.querySelector('#map-list-bg')

  if (!menuOpen.classList.contains('dn')) {

    menuOpen.classList.add('dn')
    menuClose.classList.remove('dn')

    viewToggle.classList.remove('x')
    viewToggle.classList.add('dn')

    menuPlus.classList.add('dn')

    maplistBG.classList.add('dn')
  }

  // clear list from sessionDB
  db.articles = []
  sessionDB.save(db)

  mapResultBox.classList.add('dn')
}

module.exports = mapListClear
