const mapUndoList = require('./map-list-undo')
const mapListLink = require('./map-list-link').mapListLink
const mapListClose = require('./map-list-close')
const mapClearList = require('./map-list-clear')
const splitBoxOpen = require('./expand-in-split-box').openBox
const mapListEdit = require('./map-list-edit')

function map_list_box_toolbar(articles, tags) {
  // undo last item
  const btnMapListUndo = document.querySelector('#map-list-undo')
  btnMapListUndo.addEventListener('click', (e) => mapUndoList(articles, tags))

  // edit list
  const btnEdit = document.querySelector('#scm-edit')
  btnEdit.addEventListener('click', (e) => mapListEdit({target: e, action: 'reset'}))

  // generate link
  const btnMapListLink = document.querySelector('#mlb-map-list-link')
  btnMapListLink.addEventListener('click', (e) => mapListLink(e, ['reader']))
  // smc
  const btnSmcMapListLink = document.querySelector('#smc-mlb-map-list-link')
  btnSmcMapListLink.addEventListener('click', (e) => mapListLink(e, ['reader']))

  // close box
  const btnMapListClose = document.querySelector('#map-list-close')
  btnMapListClose.addEventListener('click', (e) => mapListClose(e, articles, tags))

  // clear list
  const btnMapListClear = Array.from(document.querySelectorAll('.map-list-clear'))
  btnMapListClear.map(btn => {
    btn.addEventListener('click', (e) => mapClearList(e, articles, tags))
  })

  // expand in split-box
  const mapListSplit = document.querySelector('#map-list-expand-in-split')
  const closeMapList = true
  mapListSplit.addEventListener('click', () => {
    splitBoxOpen(articles, tags, closeMapList)
  })
}

module.exports = map_list_box_toolbar
