const html = require('nanohtml')
const raw = require('nanohtml/raw')
const createTag = require('./map-list-box').createTag
const createPost = require('./map-list-box').createPost
const icon_panel_back = require('./svg-icons').icon_panel_back
const icon_panel_minimise = require('./svg-icons').icon_panel_minimise
const icon_panel_expand = require('./svg-icons').icon_panel_expand
const icon_panel_close = require('./svg-icons').icon_panel_close
const icon_panel_share = require('./svg-icons').icon_panel_share

function map_list_box_layout(articles) {
  return html`
    <header class="z2 psa t0 l0 w100 bgc-white h2r dn bg-x xdr xw xjb pt0-5 pr0-5 pb0-5 pl0-5">
      <h4 class="fs-md-h4 ft-barlow">Mapping result</h4>
      <div class="x xdr xw xjb">
        <button type="button" id="map-list-undo" class="curp mr0-25 svg-circle-button-back-hv">
          <span class="db w19p h19p">${icon_panel_back()}</span>
        </button>
        <button type="button" id="map-list-close" class="curp mr0-25 svg-circle-button-minimise-hv">
          <span class="db w19p h19p">${icon_panel_minimise()}</span>
          <span class="dn w19p h19p">${icon_panel_expand()}</span>
        </button>
        <button type="button" class="map-list-clear curp svg-circle-button-close-hv">
          <span class="db w19p h19p">${icon_panel_close()}</span>
        </button>
      </div>
    </header>
    <div class="map-list-box collapsible-wrapper x xdc h-map-list mxh-map-list bg-pt2">
      <div class="collapsible os bg-pr0">
        <div class="psa l0 map-list-top-gradient z1"></div>
        <div id="map-result-list" class="pt0-5 pr0-5 pb4 bg-pb2 pl0-5">${render_reading_list(articles)}</div>
        <footer class="x xdr xw xac xjb psa b0 l0 r0 pr0-5 pb0-5 pl0-5 bgc-white">
          <div class="psa l0 map-list-bottom-gradient z1"></div>
          <!-- small screens --> 
          ${reader_or_map_button()}
          <button type="button" id="scm-edit" class="bg-dn x1 button-m tdn mr0-5">Edit</button>
          <button type="button" id="scm-restart" class="map-list-clear bg-dn x1 button-m tdn mr0-5">Restart</button>
          <div class="dn map-result-link psa r0 bgc-black fgc-white pt0-15 pr0-25 pb0-25 pl0-25 ft-barlow fs-button-s b-rad-3 mr0-5 z5">Reader URL copied!</div>
          <button type="button" id="smc-mlb-map-list-link" class="bg-dn x1 button-m tdn">Share</button>
          <!-- big screens -->
          <button type="button" id="map-list-expand-in-split" class="dn bg-db x1 button-s mr0-5">Expand in Splitscreen</button>
          <a id="map-list-expand-in-reader" href="/reader?" class="dn bg-db button-s x1 tdn mr0-5">Expand in Reader</a>
          <div class="dn map-result-link psa r0 bgc-black fgc-white pt0-15 pr0-25 pb0-25 pl0-25 ft-barlow fs-button-s b-rad-3 z5">Reader URL copied!</div>
        <button type="button" id="mlb-map-list-link" class="dn bg-db w19p h19p curp svg-circle-button-share-hv">${icon_panel_share()}</button>
        </footer>
      </div>
    </div>
  `
}

function reader_or_map_button() {
  if (window.location.href === '/') {
    return html`
      <a href="/reader?" class="w100 bg-dn button-m bgc-pistachio tdn mb0-5 ">Expand in Reader</a>
    `
  } else if (window.location.pathname !== '/' && window.location.pathname.length > 1) {
    return html`
      <a href="/" class="w100 bg-dn button-m bgc-pistachio tdn mb0-5 ">View in map</a>
    `
  }
}

function render_reading_list(articles) {
  const mapResultHeader = mapResultBox.querySelector('header')
  const mapResultList = document.querySelector('#map-result-list')

  return articles.map(article => {
    if (article.type === 'tag') {
      return createTag(article, mapResultList, mapResultHeader)

    } else if (article.type === 'post') {
      return createPost(article, mapResultList, mapResultHeader)
    }

  })
}

module.exports = map_list_box_layout
