"use strict";

const html = require('nanohtml')

function mapIcons(category) {

  if (category === 'default' || category === 'uncategorized' || category === 'text') {
    return html`
      <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#CAEFD0" stroke="#889AA4" stroke-width="0.75"/>
      </svg>
    `
  } else if (category === 'keyword') {
    return html`
      <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 18C13.9764 18 18 13.9765 18 9C18 4.02352 13.9764 0 9 0C4.02357 0 0 4.02352 0 9C0 13.95 4.02357 18 9 18Z" fill="#6A7880"/>
      </svg>
    `
  } else if (category === 'contributor') {
    return html`
      <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#FFE8D3" stroke="#212121" stroke-width="0.75"/>
      </svg>
    `
  } else if (category === 'photo-video') {
    return html`
      <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#FFFCE2" stroke="#FFBBB2" stroke-width="0.75"/>
      </svg>
    `
  } else if (category === 'reference') {
    return html`
      <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#D3FAFF" stroke="#6A7880" stroke-width="0.75"/>
      </svg>
    `
  } else if (category === 'sound') {
    return html`
      <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#E5E5E5" stroke="#583DC5" stroke-width="0.75"/>
      </svg>
    `
  } else if (category === 'mixed-media') {
    return html`
      <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M17.625 9C17.625 13.7694 13.7693 17.625 9 17.625C4.23139 17.625 0.375 13.7436 0.375 9C0.375 4.23063 4.23067 0.375 9 0.375C13.7693 0.375 17.625 4.23063 17.625 9Z" fill="#FFD3E8" stroke="#FF6161" stroke-width="0.75"/>
      </svg>
    `
  }

}

module.exports = mapIcons
