"use strict";

const localDB = require('./local-db')
const sessionDB = require('./session-db')

function mapHelp() {
  let localdb = localDB.getAll()

  const menuClose = document.querySelector('#map-menu-close')
  const menuOpen = document.querySelector('#map-menu-open')
  const menuPlus = document.querySelector('#map-menu-plus')

  let mapHelp = document.querySelector('#map-help')
  const viewToggle = document.querySelector('#view-toggle')
  let mapResultBox = document.querySelector('#map-result-box')
  let mapListBox = document.querySelector('.map-list-box')
  const lines = Array.from(mapHelp.querySelector('.map-help-text').children)

  if (localdb.helpText) {
    mapHelp.classList.remove('dn')
    mapHelp.classList.add('x')

    mapListBox.classList.add('map-help')
    menuOpen.classList.add('dn')
    menuClose.classList.remove('dn')

    viewToggle.classList.remove('x')
    viewToggle.classList.add('dn')
    mapResultBox.classList.add('dn', 'map-help')
  }

  const btnMapListClose = mapHelp.querySelector('#map-help-close')
  btnMapListClose.addEventListener('click', (e) => {
    mapHelp.classList.remove('x')
    mapHelp.classList.add('dn')

    mapResultBox.classList.remove('map-help')
    mapListBox.classList.remove('map-help')
    localdb.helpText = false
    localDB.save(localdb)
  })

  const btnMapLegendHelp = document.querySelector('#map-legend-help')
  btnMapLegendHelp.addEventListener('click', (e) => {
    mapHelp.classList.remove('dn')
    mapHelp.classList.add('x') 

    if (!menuOpen.classList.contains('dn')) {
      menuOpen.classList.add('dn')
      menuClose.classList.remove('dn')

      let sessiondb = sessionDB.getAll()
      if (sessiondb.articles.length > 0) {
        menuPlus.classList.remove('dn')
      }
    }

    viewToggle.classList.remove('x')
    viewToggle.classList.add('dn')

    mapResultBox.classList.add('dn', 'map-help')
    mapListBox.classList.add('map-help')
    
    localdb.helpText = true
    localDB.save(localdb)
  })

  // -- move through intro texts
  const btnReadMore = mapHelp.querySelector('#map-help-more')

  let idx = 0
  btnReadMore.addEventListener('click', moveTextSlide)

  function moveTextSlide() {
    if (idx >= lines.length -1) {
      idx = -1 
    }
    idx++

    if (idx !== 0) {
      lines[idx].classList.add('fade-in')
    }

    // while going forward, we hide the previous text
    if (lines[idx].previousElementSibling !== null) {
      lines[idx].previousElementSibling.classList.remove('x')
      lines[idx].previousElementSibling.classList.add('op0')
      lines[idx].previousElementSibling.classList.remove('fade-in')
    } else {
      // else we hide the last text in the list
      // (for when we start from the beginning)
      lines[lines.length -1].classList.remove('x')
      lines[lines.length -1].classList.add('op0')
      lines[lines.length -1].classList.remove('fade-in')
    }

    lines[idx].classList.remove('op0')

    // swap the "Read More" button with "Close"
    // and allow btnReadMore to close the box
    if (idx === lines.length -1) {
      btnReadMore.innerText = "Close"

      btnReadMore.removeEventListener('click', moveTextSlide)
      btnReadMore.addEventListener('click', closeTextSlide)

      idx = 0 

    } else {
      btnReadMore.innerText = "Read More"
    }

  }

  function closeTextSlide() {
    mapHelp.classList.remove('x')
    mapHelp.classList.add('dn')

    mapResultBox.classList.remove('map-help')
    mapListBox.classList.remove('map-help')

    lines[lines.length -1].classList.remove('x')
    lines[lines.length -1].classList.add('op0')
    lines[lines.length -1].classList.remove('fade-in')

    lines[0].classList.remove('op0')
    lines[0].classList.add('x')
    btnReadMore.innerText = "Read More"

    localdb.helpText = false
    localDB.save(localdb)

    btnReadMore.removeEventListener('click', closeTextSlide)
    btnReadMore.addEventListener('click', moveTextSlide)
  }

}

module.exports = mapHelp
