"use strict";

const DB = 'TWLA'

// -- DB init
function dbInit() {
  try {
    if (localStorage.getItem(DB) === null) {
      localStorage.setItem(DB, JSON.stringify({
        splash: true,
        helpText: true
      }))
    }

    let db = dbGetAll()
    localStorage.setItem(DB, JSON.stringify(db))

  } catch (err) {
    console.log("can't use localStorage.")
  }
}

function dbGetAll() {
  try {
    const db = JSON.parse(localStorage.getItem(DB))
    return db
  } catch (err) {
    console.log("local.db can't be accessed =>", err)
    return {
      splash: true,
      helpText: true
    }
  }
}

function dbSave(newState) {
  localStorage.setItem(DB, JSON.stringify(newState))
}

module.exports = {
  init: dbInit,
  getAll: dbGetAll,
  save: dbSave
}
