"use strict";

const results = document.querySelector('#results')
if (results !== null) {

  const result_list = Array.from(results.children)

  const header_wrap = document.querySelector('#header-sort-by')
  let headers = []
  Array.from(header_wrap.querySelectorAll('[data-sort]')).map(header => {
    headers.push(header.dataset.sort)
    header.addEventListener('click', sort_by_field(header, header.dataset.sort, result_list), false)
  })

}

function sort_by_field(header, field, result_list) {
  return () => {

    const sorted_by_header = document.querySelector('#header-sort-by')
    const sorted_by_value = sorted_by_header.dataset.sortby
    const is_header_sorted = header.querySelector('span')
    let sort_status = 0

    // if clicked header has sort-by arrow already,
    // just flip it
    if (!is_header_sorted.classList.contains('dn')) {
      if (is_header_sorted.innerText === '↑') {
        is_header_sorted.innerHTML = '&darr;'
        sort_status = -1
      } else {
        is_header_sorted.innerHTML = '&uarr;'
        sort_status = 1
      }
    } else {
      // else, remove arrow from current sorted-by header
      // and add it to clicked header
      sorted_by_header.querySelector(`#sort-by-${sorted_by_value} span`).classList.toggle('dn')
      sorted_by_header.setAttribute('data-sortby', header.dataset.sort)

      header.querySelector('span').classList.toggle('dn')
    }

    result_list.sort((a, b) => {
      let item_a
      let item_b
      const a_list = Array.from(a.children)
      const b_list = Array.from(b.children)

      if (field === 'title') {
        item_a = getFieldText(a_list, 'title')
        item_b = getFieldText(b_list, 'title')

      } else if (field === 'contributors') {
        item_a = getFieldText(a_list, 'contributors')
        item_b = getFieldText(b_list, 'contributors')

      } else if (field === 'date') {
        item_a = getFieldDate(a_list, 'date')
        item_b = getFieldDate(b_list, 'date')
      }

      if (item_a < item_b) {
        return -1
      }
      if (item_a > item_b) {
        return 1
      }

      return 0

    })

    function getFieldText(list, field) {
      if (list[0].dataset.type === 'tag') {
        let item_q = list.find(item => item.dataset.type)
        if (item_q !== undefined) {
          return item_q.innerText.toUpperCase()
        }

      } else {
        if (field === 'title') {
          let item_q = list.find(item => item.dataset.type)
          let header = list.find(item => item.dataset.type === 'header')

          if (header !== undefined) {
            let title = Array.from(header.children[0].children)
                .find(item => item.dataset.type === field)
            
            if (title !== undefined) {
              return title.innerText.toUpperCase()
            } 
          } else {
            // eg for search results when sorting by title
            if (item_q !== undefined && item_q.dataset.type === field) {
              return item_q.innerText.toUpperCase()
            }
          }
        } else {
          let item_q = list.find(item => item.dataset.type === field)

          // eg it's a tag item and has not `field: desc`
          if (item_q === undefined) {
            return ''
          } else if (item_q.dataset.type === field) {
            return item_q.innerText.toUpperCase()
          }
        }
      }
    }

    function getFieldDate(list, field) {
      let item_q = list.find(item => item.dataset.type === field)
      if (item_q !== undefined && item_q.dataset.type === field) {
        return new Date(item_q.innerText.split('.').reverse().join('-'))
      }
    }

    // check if it needs to be reversed
    if (sort_status !== 1) {
      result_list.reverse()
    }
    result_list.forEach(result => {
      return results.append(result)
    })

  } 
}

