"use strict";

async function fetchGET(url) {
  const response = await fetch(url)
  return await response.json()
}

async function fetchPOST(url, data) {
  // <https://stackoverflow.com/a/66589239>
  const response = await fetch(url, {
    method: 'POST',
    credentials: 'same-origin',
    headers: {
      'Content-type': 'application/json',
      'X-WP-Nonce' : wpApiSettings.nonce
    },
    body: JSON.stringify(data)
  })

  return await response.json()
}

async function fetchPUT(url, data) {
  // <https://stackoverflow.com/a/66589239>
  const response = await fetch(url, {
    method: 'PUT',
    credentials: 'same-origin',
    headers: {
      'Content-type': 'application/json',
      'X-WP-Nonce' : wpApiSettings.nonce
    },
    body: JSON.stringify(data)
  })

  return await response.json()
}

module.exports = {
  get: fetchGET,
  post: fetchPOST,
  put: fetchPUT
}
