"use strict";

const sessionDB = require('./session-db')
const {navToggleSplit} = require('./nav-toggle-buttons.js')
const {createSplitBoxItem, makeSplitReaderList} = require('./create-split-box-item')
const generateURL = require('./map-list-link').generateURL
const mapListClose = require('./map-list-close')
const {mapListBox} = require('./map-list-box')
const {splitBoxLayout} = require('./create-split-box-item')

function expandInSplitBox(articles, tags) {
  const mapResultBox = document.querySelector('#map-result-box')
  const mapResultList = mapResultBox.querySelector('#map-result-list')

  const splitBox = document.querySelector('#split-box') 
  const isSplitBoxOpen = !splitBox.classList.contains('dn')
  const splitBoxList = document.querySelector('#split-box-list')
  const splitButton = document.querySelector('#toggle-split')

  if (!isSplitBoxOpen) {
    openBox(articles, tags, true)

  } else {
    // clear all articles and close box
    if (splitBoxList !== null) {
      Array.from(splitBoxList.children).forEach(item => {
        item.remove()
      })

      splitBox.classList.add('dn')

      const closeButton = document.querySelector('#map-list-close')
      mapListClose(closeButton, articles, tags)
      mapListBox(articles, tags, false, false)
    }
  }
}

function openBox(articles, tags, closeMapList) {

  const mapResultBox = document.querySelector('#map-result-box')
  const splitBox = document.querySelector('#split-box') 
  let splitBoxList = document.querySelector('#split-box-list')
  const isSplitBoxOpen = !splitBox.classList.contains('dn') 
  
  navToggleSplit()

  // -- close map-list-box
  if (closeMapList) {
    let mapResultList = document.querySelector('#map-result-list')
    Array.from(mapResultList.children).forEach(item => {
      item.remove()
    })

    const closeButton = document.querySelector('#map-list-close')
    mapListClose(closeButton, articles, tags)
  }

  // --

  // check if split-box is displaying single node
  // or list, and make sure we can append a new list to it
  if (splitBoxList === null) {
    // remove everything from split-box (article-view)
    Array.from(splitBox.children).map(block => block.remove())

    let layout = splitBoxLayout(splitBox)
    splitBox.appendChild(layout)
    splitBoxList = layout
  }

  function manageSplitBox() {
    if (window.innerWidth <= 1024) {
      splitBox.classList.add('dn')

    } else if (!isSplitBoxOpen) {
      splitBox.classList.remove('dn')
      const loading = document.createElement('p')
      loading.innerHTML = "Loading..."
      splitBoxList.append(loading)

      // populate w/ articles, if any 
      if (sessionDB.exists()) {
        const db = sessionDB.getAll()

        if (db.articles.length > 0) {
          loading.remove()
          makeSplitReaderList(tags, articles)
        }
      }
    }
  }

  manageSplitBox()
  window.addEventListener('resize', () => {
    manageSplitBox()
  })

}

module.exports = {expandInSplitBox, 
                  openBox}
