"use strict";

const mapUITag = require('./map-ui-tag')
const mapUIPost = require('./map-ui-post')

function drawMap(map, points, nodeType, graph, EPSILON) {
  // add vertices to graph
  let verts = points.map((point, i) => point.map_location)
  ear.graph.add_vertices(graph, verts, 0);

  // populate graph with dots and return dots
  // eg list of HTML nodes
  return graph.vertices_coords.map((coord, i) => {
    // add circle
    const dot = map.circle(coord)
          .radius(1)
          .fill('#6A7880')
          .addClass(`node-map node-${nodeType} circle-${points[i].id} curp`)
          .setAttributes({'data-idx': i,
                          'data-id': points[i].id,
                          'data-type': "keyword"
                         })

    // render UI level
    if (nodeType === 'tag') {
      mapUITag(points[i])
    } else if (nodeType === 'post') {
      mapUIPost(points[i])
    }

  })
}

module.exports = drawMap
