"use strict";

const fetchPOST = require('./fetch').post

async function articleLocationBatchUpdate () {
  const articleNodes = Array.from(document.querySelectorAll(`[data-type='post']`))

  const articleData = articleNodes.map(article => {
    return {
      id: Number(article.dataset.id),
      position_x: Number(article.dataset.x),
      position_y: Number(article.dataset.y)
    }
  })

  const t = await fetchPOST('/wp-json/batch/v1/posts', articleData)
        .catch((err) => {
          console.log('err =>', err)
        })

  console.log('save-map =>', t)

}

module.exports = articleLocationBatchUpdate
